/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.state;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestClusterStateAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        Set<String> metrics;
        boolean isAllMetricsOnly;
        boolean isAllIndicesOnly;
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.listenerThreaded(false);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        boolean bl2 = isAllMetricsOnly = (metrics = Strings.splitStringByCommaToSet(request.param("metric", "_all"))).size() == 1 && metrics.contains("_all");
        if (!isAllMetricsOnly) {
            clusterStateRequest.nodes(metrics.contains("nodes") || metrics.contains("master_node"));
            clusterStateRequest.routingTable(metrics.contains("routing_table"));
            clusterStateRequest.metaData(metrics.contains("metadata"));
            clusterStateRequest.blocks(metrics.contains("blocks"));
            clusterStateRequest.indexTemplates(request.paramAsStringArray("index_templates", Strings.EMPTY_ARRAY));
        }
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(ClusterStateResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field(Fields.CLUSTER_NAME, response.getClusterName().value());
                    response.getState().settingsFilter(RestClusterStateAction.this.settingsFilter).toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                if (RestClusterStateAction.this.logger.isDebugEnabled()) {
                    RestClusterStateAction.this.logger.debug("failed to handle cluster state", e, new Object[0]);
                }
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestClusterStateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString CLUSTER_NAME = new XContentBuilderString("cluster_name");

        Fields() {
        }
    }
}

