/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.sum;

import java.io.IOException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class SumAggregator
extends MetricsAggregator.SingleValue {
    private final NumericValuesSource valuesSource;
    private DoubleArray sums;

    public SumAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.sums = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (this.valuesSource != null) : "collect must only be called after #shouldCollect returns true";
        DoubleValues values = this.valuesSource.doubleValues();
        if (values == null) {
            return;
        }
        this.sums = BigArrays.grow(this.sums, owningBucketOrdinal + 1L);
        int valuesCount = values.setDocument(doc);
        double sum = 0.0;
        for (int i = 0; i < valuesCount; ++i) {
            sum += values.nextValue();
        }
        this.sums.increment(owningBucketOrdinal, sum);
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalSum(this.name, 0.0);
        }
        return new InternalSum(this.name, this.sums.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.sums);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig) {
            super(name, InternalSum.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new SumAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new SumAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

