/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.FieldDataSource;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.geopoints.GeoPointValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class AggregationContext
implements ReaderContextAware,
ScorerAware {
    private final SearchContext searchContext;
    private ObjectObjectOpenHashMap<ConfigCacheKey, FieldDataSource>[] perDepthFieldDataSources = new ObjectObjectOpenHashMap[4];
    private List<ReaderContextAware> readerAwares = new ArrayList<ReaderContextAware>();
    private List<ScorerAware> scorerAwares = new ArrayList<ScorerAware>();
    private AtomicReaderContext reader;
    private Scorer scorer;

    public AggregationContext(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public SearchContext searchContext() {
        return this.searchContext;
    }

    public CacheRecycler cacheRecycler() {
        return this.searchContext.cacheRecycler();
    }

    public PageCacheRecycler pageCacheRecycler() {
        return this.searchContext.pageCacheRecycler();
    }

    public AtomicReaderContext currentReader() {
        return this.reader;
    }

    public Scorer currentScorer() {
        return this.scorer;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.reader = reader;
        for (ReaderContextAware aware : this.readerAwares) {
            aware.setNextReader(reader);
        }
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.scorer = scorer;
        for (ScorerAware scorerAware : this.scorerAwares) {
            scorerAware.setScorer(scorer);
        }
    }

    public <VS extends ValuesSource> VS valuesSource(ValuesSourceConfig<VS> config, int depth) {
        assert (config.valid()) : "value source config is invalid - must have either a field context or a script or marked as unmapped";
        assert (!config.unmapped) : "value source should not be created for unmapped fields";
        if (this.perDepthFieldDataSources.length <= depth) {
            this.perDepthFieldDataSources = Arrays.copyOf(this.perDepthFieldDataSources, ArrayUtil.oversize((int)(1 + depth), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        if (this.perDepthFieldDataSources[depth] == null) {
            this.perDepthFieldDataSources[depth] = new ObjectObjectOpenHashMap();
        }
        ObjectObjectOpenHashMap<ConfigCacheKey, FieldDataSource> fieldDataSources = this.perDepthFieldDataSources[depth];
        if (config.fieldContext == null) {
            if (NumericValuesSource.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.numericScript(config);
            }
            if (BytesValuesSource.class.isAssignableFrom(config.valueSourceType)) {
                return (VS)this.bytesScript(config);
            }
            throw new AggregationExecutionException("value source of type [" + config.valueSourceType.getSimpleName() + "] is not supported by scripts");
        }
        if (NumericValuesSource.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.numericField(fieldDataSources, config);
        }
        if (GeoPointValuesSource.class.isAssignableFrom(config.valueSourceType)) {
            return (VS)this.geoPointField(fieldDataSources, config);
        }
        return (VS)this.bytesField(fieldDataSources, config);
    }

    private NumericValuesSource numericScript(ValuesSourceConfig<?> config) {
        this.setScorerIfNeeded(config.script);
        this.setReaderIfNeeded(config.script);
        this.scorerAwares.add(config.script);
        this.readerAwares.add(config.script);
        FieldDataSource.Numeric source = new FieldDataSource.Numeric.Script(config.script, config.scriptValueType);
        if (config.ensureUnique || config.ensureSorted) {
            source = new FieldDataSource.Numeric.SortedAndUnique(source);
            this.readerAwares.add((ReaderContextAware)((Object)source));
        }
        return new NumericValuesSource(source, config.formatter(), config.parser());
    }

    private NumericValuesSource numericField(ObjectObjectOpenHashMap<ConfigCacheKey, FieldDataSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        FieldDataSource.Numeric dataSource = (FieldDataSource.Numeric)fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            FieldDataSource.MetaData metaData = FieldDataSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = new FieldDataSource.Numeric.FieldData((IndexNumericFieldData)config.fieldContext.indexFieldData(), metaData);
            this.setReaderIfNeeded((ReaderContextAware)((Object)dataSource));
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.script != null) {
            this.setScorerIfNeeded(config.script);
            this.setReaderIfNeeded(config.script);
            this.scorerAwares.add(config.script);
            this.readerAwares.add(config.script);
            dataSource = new FieldDataSource.Numeric.WithScript(dataSource, config.script);
            if (config.ensureUnique || config.ensureSorted) {
                dataSource = new FieldDataSource.Numeric.SortedAndUnique(dataSource);
                this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            }
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        return new NumericValuesSource(dataSource, config.formatter(), config.parser());
    }

    private ValuesSource bytesField(ObjectObjectOpenHashMap<ConfigCacheKey, FieldDataSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        FieldDataSource dataSource = fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            IndexFieldData<?> indexFieldData = config.fieldContext.indexFieldData();
            FieldDataSource.MetaData metaData = FieldDataSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = indexFieldData instanceof IndexFieldData.WithOrdinals ? new FieldDataSource.Bytes.WithOrdinals.FieldData((IndexFieldData.WithOrdinals)indexFieldData, metaData) : new FieldDataSource.Bytes.FieldData(indexFieldData, metaData);
            this.setReaderIfNeeded((ReaderContextAware)((Object)dataSource));
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.script != null) {
            this.setScorerIfNeeded(config.script);
            this.setReaderIfNeeded(config.script);
            this.scorerAwares.add(config.script);
            this.readerAwares.add(config.script);
            dataSource = new FieldDataSource.WithScript(dataSource, config.script);
        }
        if (config.ensureUnique && !dataSource.metaData().uniqueness().unique() || config.ensureSorted) {
            dataSource = new FieldDataSource.Bytes.SortedAndUnique(dataSource);
            this.readerAwares.add((ReaderContextAware)((Object)dataSource));
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        if (dataSource instanceof FieldDataSource.Bytes.WithOrdinals) {
            return new BytesValuesSource.WithOrdinals((FieldDataSource.Bytes.WithOrdinals)dataSource);
        }
        return new BytesValuesSource(dataSource);
    }

    private BytesValuesSource bytesScript(ValuesSourceConfig<?> config) {
        this.setScorerIfNeeded(config.script);
        this.setReaderIfNeeded(config.script);
        this.scorerAwares.add(config.script);
        this.readerAwares.add(config.script);
        FieldDataSource.Bytes source = new FieldDataSource.Bytes.Script(config.script);
        if (config.ensureUnique || config.ensureSorted) {
            source = new FieldDataSource.Bytes.SortedAndUnique(source);
            this.readerAwares.add((ReaderContextAware)((Object)source));
        }
        return new BytesValuesSource(source);
    }

    private GeoPointValuesSource geoPointField(ObjectObjectOpenHashMap<ConfigCacheKey, FieldDataSource> fieldDataSources, ValuesSourceConfig<?> config) {
        ConfigCacheKey cacheKey = new ConfigCacheKey(config);
        FieldDataSource.GeoPoint dataSource = (FieldDataSource.GeoPoint)fieldDataSources.get(cacheKey);
        if (dataSource == null) {
            FieldDataSource.MetaData metaData = FieldDataSource.MetaData.load(config.fieldContext.indexFieldData(), this.searchContext);
            dataSource = new FieldDataSource.GeoPoint((IndexGeoPointFieldData)config.fieldContext.indexFieldData(), metaData);
            this.setReaderIfNeeded(dataSource);
            this.readerAwares.add(dataSource);
            fieldDataSources.put(cacheKey, dataSource);
        }
        if (config.needsHashes) {
            dataSource.setNeedsHashes(true);
        }
        return new GeoPointValuesSource(dataSource);
    }

    public void registerReaderContextAware(ReaderContextAware readerContextAware) {
        this.setReaderIfNeeded(readerContextAware);
        this.readerAwares.add(readerContextAware);
    }

    public void registerScorerAware(ScorerAware scorerAware) {
        this.setScorerIfNeeded(scorerAware);
        this.scorerAwares.add(scorerAware);
    }

    private void setReaderIfNeeded(ReaderContextAware readerAware) {
        if (this.reader != null) {
            readerAware.setNextReader(this.reader);
        }
    }

    private void setScorerIfNeeded(ScorerAware scorerAware) {
        if (this.scorer != null) {
            scorerAware.setScorer(this.scorer);
        }
    }

    private static class ConfigCacheKey {
        private final String field;
        private final Class<? extends ValuesSource> valueSourceType;

        private ConfigCacheKey(ValuesSourceConfig config) {
            this.field = config.fieldContext.field();
            this.valueSourceType = config.valueSourceType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigCacheKey that = (ConfigCacheKey)o;
            if (!this.field.equals(that.field)) {
                return false;
            }
            return this.valueSourceType.equals(that.valueSourceType);
        }

        public int hashCode() {
            int result = this.field.hashCode();
            result = 31 * result + this.valueSourceType.hashCode();
            return result;
        }
    }
}

