/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.source;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.fetch.source.FetchSourceParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class FetchSourceSubPhase
implements FetchSubPhase {
    @Inject
    public FetchSourceSubPhase() {
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FetchSourceParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("_source", new FetchSourceParseElement());
        return parseElements.build();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.sourceRequested();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        FetchSourceContext fetchSourceContext = context.fetchSourceContext();
        assert (fetchSourceContext.fetchSource());
        if (fetchSourceContext.includes().length == 0 && fetchSourceContext.excludes().length == 0) {
            hitContext.hit().sourceRef(context.lookup().source().internalSourceRef());
            return;
        }
        Object value = context.lookup().source().filter(fetchSourceContext.includes(), fetchSourceContext.excludes());
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(context.lookup().source().sourceContentType());
            builder.value(value);
            hitContext.hit().sourceRef(builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error filtering source", e);
        }
    }
}

