/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.decoder;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.vysper.charset.CharsetUtil;
import org.apache.vysper.xml.decoder.XMLElementBuilderFactory;
import org.apache.vysper.xml.decoder.XMPPContentHandler;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.sax.NonBlockingXMLReader;
import org.apache.vysper.xml.sax.impl.DefaultNonBlockingXMLReader;

public class XMPPDecoder
extends CumulativeProtocolDecoder {
    private static final String XML_DECL = "<?xml";
    private static final String STREAM_STREAM = "<stream:stream";
    public static final String SESSION_ATTRIBUTE_NAME = "xmppParser";
    private XMLElementBuilderFactory builderFactory = new XMLElementBuilderFactory();

    public XMPPDecoder() {
    }

    public XMPPDecoder(XMLElementBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        NonBlockingXMLReader reader = (NonBlockingXMLReader)session.getAttribute((Object)SESSION_ATTRIBUTE_NAME);
        if (reader == null) {
            reader = new DefaultNonBlockingXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://mina.apache.org/vysper/features/restart-allowed", true);
            reader.setProperty("http://mina.apache.org/vysper/properties/restart-qname", "stream:stream");
            reader.setContentHandler(new XMPPContentHandler(this.builderFactory));
            session.setAttribute((Object)SESSION_ATTRIBUTE_NAME, (Object)reader);
        }
        XMPPContentHandler contentHandler = (XMPPContentHandler)reader.getContentHandler();
        contentHandler.setListener(new MinaStanzaListener(out));
        reader.parse(in, CharsetUtil.UTF8_DECODER);
        return false;
    }

    public static class MinaStanzaListener
    implements XMPPContentHandler.StanzaListener {
        private ProtocolDecoderOutput protocolDecoder;

        public MinaStanzaListener(ProtocolDecoderOutput protocolDecoder) {
            this.protocolDecoder = protocolDecoder;
        }

        public void stanza(XMLElement element) {
            if (element.getName().equals("stream")) {
                // empty if block
            }
            this.protocolDecoder.write((Object)element);
        }
    }
}

