/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnector;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbResultHandler
implements StanzaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DbResultHandler.class);

    public String getName() {
        return "result";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        if (!this.getName().equals(stanza.getName())) {
            return false;
        }
        String namespaceURI = stanza.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return namespaceURI.equals("jabber:server:dialback");
    }

    public boolean isSessionRequired() {
        return false;
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        String type = stanza.getAttributeValue("type");
        if (type == null) {
            String streamId = sessionContext.getSessionId();
            String dailbackId = stanza.getInnerText().getText();
            EntityImpl receiving = EntityImpl.parseUnchecked(stanza.getAttributeValue("from"));
            Entity originating = serverRuntimeContext.getServerEnitity();
            try {
                XMPPServerConnector connector = serverRuntimeContext.getServerConnectorRegistry().connectForDialback(receiving, sessionContext, sessionStateHolder);
                StanzaBuilder verifyBuilder = new StanzaBuilder("verify", "jabber:server:dialback", "db");
                verifyBuilder.addAttribute("from", originating.getFullQualifiedName());
                verifyBuilder.addAttribute("to", receiving.getFullQualifiedName());
                verifyBuilder.addAttribute("id", sessionContext.getSessionId());
                verifyBuilder.addText(dailbackId);
                connector.write((Stanza)verifyBuilder.build());
                return null;
            }
            catch (Exception e) {
                StanzaBuilder builder = new StanzaBuilder("result", "jabber:server:dialback", "db");
                builder.addAttribute("from", originating.getDomain());
                builder.addAttribute("to", receiving.getDomain());
                builder.addAttribute("type", "invalid");
                return new ResponseStanzaContainerImpl((Stanza)builder.build());
            }
        }
        if ("valid".equals(type)) {
            sessionStateHolder.setState(SessionState.AUTHENTICATED);
            EntityImpl receiving = EntityImpl.parseUnchecked(stanza.getAttributeValue("from"));
            LOG.info("XMPP server connector to {} authenticated using dialback", (Object)receiving);
        }
        return null;
    }
}

