/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SystemSession;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.DefaultAccessManager;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.SecurityConstants;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.authentication.AuthContextProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlProviderFactory;
import org.apache.jackrabbit.core.security.authorization.AccessControlProviderFactoryImpl;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.core.security.principal.DefaultPrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalManagerImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.apache.jackrabbit.core.security.principal.ProviderRegistryImpl;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityManager
implements JackrabbitSecurityManager {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultSecurityManager.class);
    private boolean initialized;
    private RepositoryImpl repository;
    private SystemSession securitySession;
    private UserManager systemUserManager;
    private PrincipalManager systemPrincipalManager;
    private String adminId;
    private String anonymousId;
    private final Map acProviders = new HashMap();
    private AccessControlProviderFactory acProviderFactory;
    private WorkspaceAccessManager workspaceAccessManager;
    private PrincipalProviderRegistry principalProviderRegistry;
    private AuthContextProvider authContextProvider;

    public synchronized void init(Repository repository, Session systemSession) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(repository instanceof RepositoryImpl)) {
            throw new RepositoryException("RepositoryImpl expected");
        }
        if (!(systemSession instanceof SystemSession)) {
            throw new RepositoryException("SystemSession expected");
        }
        this.securitySession = (SystemSession)systemSession;
        this.repository = (RepositoryImpl)repository;
        SecurityConfig config = this.repository.getConfig().getSecurityConfig();
        LoginModuleConfig loginModConf = config.getLoginModuleConfig();
        this.authContextProvider = new AuthContextProvider(config.getAppName(), loginModConf);
        if (this.authContextProvider.isJAAS()) {
            log.info("init: use JAAS login-configuration for " + config.getAppName());
        } else if (this.authContextProvider.isLocal()) {
            log.info("init: use Repository Login-Configuration for " + config.getAppName());
        } else {
            String msg = "Neither JAAS nor RepositoryConfig contained a valid Configuriation for " + config.getAppName();
            log.error(msg);
            throw new RepositoryException(msg);
        }
        Properties[] moduleConfig = this.authContextProvider.getModuleConfig();
        for (int i = 0; i < moduleConfig.length; ++i) {
            if (moduleConfig[i].containsKey("adminId")) {
                this.adminId = moduleConfig[i].getProperty("adminId");
            }
            if (!moduleConfig[i].containsKey("anonymousId")) continue;
            this.anonymousId = moduleConfig[i].getProperty("anonymousId");
        }
        if (this.adminId == null) {
            log.debug("No adminID defined in LoginModule/JAAS config -> using default.");
            this.adminId = "admin";
        }
        if (this.anonymousId == null) {
            log.debug("No anonymousID defined in LoginModule/JAAS config -> using default.");
            this.anonymousId = "anonymous";
        }
        this.systemUserManager = new UserManagerImpl(this.securitySession, this.adminId);
        DefaultSecurityManager.createSystemUsers(this.systemUserManager, this.adminId, this.anonymousId);
        this.acProviderFactory = new AccessControlProviderFactoryImpl();
        this.acProviderFactory.init((Session)this.securitySession);
        SecurityManagerConfig smc = config.getSecurityManagerConfig();
        if (smc != null && smc.getWorkspaceAccessConfig() != null) {
            this.workspaceAccessManager = (WorkspaceAccessManager)smc.getWorkspaceAccessConfig().newInstance();
        } else {
            log.debug("No WorkspaceAccessManager configured; using default.");
            this.workspaceAccessManager = new WorkspaceAccessManagerImpl();
        }
        this.workspaceAccessManager.init((Session)this.securitySession);
        DefaultPrincipalProvider defaultPP = new DefaultPrincipalProvider((Session)this.securitySession, (UserManagerImpl)this.systemUserManager);
        defaultPP.init(new Properties());
        this.principalProviderRegistry = new ProviderRegistryImpl(defaultPP);
        for (int i = 0; i < moduleConfig.length; ++i) {
            this.principalProviderRegistry.registerProvider(moduleConfig[i]);
        }
        this.systemPrincipalManager = new PrincipalManagerImpl((Session)this.securitySession, this.principalProviderRegistry.getProviders());
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String workspaceName) {
        this.checkInitialized();
        Map map = this.acProviders;
        synchronized (map) {
            AccessControlProvider prov = (AccessControlProvider)this.acProviders.remove(workspaceName);
            if (prov != null) {
                prov.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.checkInitialized();
        Map map = this.acProviders;
        synchronized (map) {
            Iterator itr = this.acProviders.values().iterator();
            while (itr.hasNext()) {
                ((AccessControlProvider)itr.next()).close();
            }
            this.acProviders.clear();
        }
    }

    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        this.checkInitialized();
        AccessManagerConfig amConfig = this.repository.getConfig().getSecurityConfig().getAccessManagerConfig();
        try {
            AccessManager accessMgr;
            String wspName = session.getWorkspace().getName();
            AccessControlProvider pp = this.getAccessControlProvider(wspName);
            if (amConfig == null) {
                log.debug("No configuration entry for AccessManager. Using org.apache.jackrabbit.core.security.DefaultAccessManager");
                accessMgr = new DefaultAccessManager();
            } else {
                accessMgr = (AccessManager)amConfig.newInstance();
            }
            accessMgr.init(amContext, pp, this.workspaceAccessManager);
            return accessMgr;
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Failed to instantiate AccessManager (" + amConfig.getClassName() + ")";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public synchronized PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session == this.securitySession) {
            return this.systemPrincipalManager;
        }
        if (session instanceof SessionImpl) {
            SessionImpl sImpl = (SessionImpl)session;
            return new PrincipalManagerImpl((Session)sImpl, this.principalProviderRegistry.getProviders());
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        this.checkInitialized();
        if (session == this.securitySession) {
            return this.systemUserManager;
        }
        if (session instanceof SessionImpl) {
            String workspaceName = this.securitySession.getWorkspace().getName();
            try {
                SessionImpl sImpl = (SessionImpl)session;
                SessionImpl s = (SessionImpl)sImpl.createSession(workspaceName);
                return new UserManagerImpl(s, this.adminId);
            }
            catch (NoSuchWorkspaceException e) {
                throw new AccessControlException("Cannot build UserManager for " + session.getUserID(), (Throwable)e);
            }
        }
        throw new RepositoryException("Internal error: SessionImpl expected.");
    }

    public String getUserID(Subject subject) throws RepositoryException {
        this.checkInitialized();
        if (!subject.getPrincipals(AdminPrincipal.class).isEmpty()) {
            return this.adminId;
        }
        String uid = null;
        Iterator creds = subject.getPublicCredentials(SimpleCredentials.class).iterator();
        if (creds.hasNext()) {
            SimpleCredentials sc = (SimpleCredentials)creds.next();
            uid = sc.getUserID();
        } else {
            Iterator<Principal> it = subject.getPrincipals().iterator();
            while (it.hasNext()) {
                Authorizable authorz;
                Principal p = it.next();
                if (p instanceof Group || (authorz = this.systemUserManager.getAuthorizable(p)) == null || authorz.isGroup()) continue;
                uid = ((User)authorz).getID();
                break;
            }
        }
        return uid;
    }

    public AuthContext getAuthContext(Credentials creds, Subject subject) throws RepositoryException {
        this.checkInitialized();
        return this.authContextProvider.getAuthContext(creds, subject, (Session)this.securitySession, this.principalProviderRegistry, this.adminId, this.anonymousId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessControlProvider getAccessControlProvider(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        this.checkInitialized();
        Map map = this.acProviders;
        synchronized (map) {
            AccessControlProvider provider = (AccessControlProvider)this.acProviders.get(workspaceName);
            if (provider == null) {
                SystemSession systemSession = this.repository.getSystemSession(workspaceName);
                WorkspaceConfig conf = this.repository.getConfig().getWorkspaceConfig(workspaceName);
                WorkspaceSecurityConfig secConf = conf == null ? null : conf.getSecurityConfig();
                provider = this.acProviderFactory.createProvider((Session)systemSession, secConf);
                this.acProviders.put(workspaceName, provider);
            }
            return provider;
        }
    }

    private static void createSystemUsers(UserManager userManager, String adminId, String anonymousId) throws RepositoryException {
        Authorizable anonymous;
        Authorizable admin;
        PrincipalImpl pr = new PrincipalImpl("administrators");
        Group admins = (Group)userManager.getAuthorizable((Principal)pr);
        if (admins == null) {
            admins = userManager.createGroup((Principal)new PrincipalImpl("administrators"));
            log.debug("...created administrators group with name 'administrators'");
        }
        if (adminId != null && (admin = userManager.getAuthorizable(adminId)) == null) {
            admin = userManager.createUser(adminId, adminId);
            log.info("...created admin-user with id '" + adminId + "' ...");
            admins.addMember(admin);
            log.info("...added admin '" + adminId + "' as member of the administrators group.");
        }
        if (anonymousId != null && (anonymous = userManager.getAuthorizable(anonymousId)) == null) {
            userManager.createUser(anonymousId, "");
            log.info("...created anonymous-user with id '" + anonymousId + "' ...");
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    private class WorkspaceAccessManagerImpl
    implements SecurityConstants,
    WorkspaceAccessManager {
        private WorkspaceAccessManagerImpl() {
        }

        public void init(Session securitySession) throws RepositoryException {
        }

        public void close() throws RepositoryException {
        }

        public boolean grants(Set principals, String workspaceName) throws RepositoryException {
            try {
                AccessControlProvider prov = DefaultSecurityManager.this.getAccessControlProvider(workspaceName);
                return prov.canAccessRoot(principals);
            }
            catch (NoSuchWorkspaceException e) {
                return false;
            }
        }
    }
}

