/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRenderViewEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.PreValidateEvent;

public class NamedEventManager {
    private HashMap<String, Collection<Class<? extends ComponentSystemEvent>>> events = new HashMap(6, 1.0f);

    public NamedEventManager() {
        this.addNamedEvent("postAddToView", PostAddToViewEvent.class);
        this.addNamedEvent("preRenderView", PreRenderViewEvent.class);
        this.addNamedEvent("preRenderComponent", PreRenderComponentEvent.class);
        this.addNamedEvent("preValidate", PreValidateEvent.class);
        this.addNamedEvent("postValidate", PostValidateEvent.class);
        this.addNamedEvent("postRenderView", PostRenderViewEvent.class);
    }

    public void addNamedEvent(String shortName, Class<? extends ComponentSystemEvent> cls) {
        String key = shortName;
        if (shortName == null) {
            key = this.getFixedName(cls);
        }
        Collection eventList = this.events.computeIfAbsent(key, k -> new LinkedList());
        eventList.add(cls);
    }

    public Collection<Class<? extends ComponentSystemEvent>> getNamedEvent(String shortName) {
        return this.events.get(shortName);
    }

    private String getFixedName(Class<? extends ComponentSystemEvent> cls) {
        StringBuilder result = new StringBuilder();
        String className = cls.getSimpleName();
        if (className.toLowerCase().endsWith("event")) {
            className = className.substring(0, result.length() - 5);
        }
        if (cls.getPackage() != null) {
            result.append(cls.getPackage().getName());
            result.append('.');
        }
        result.append(className);
        return result.toString();
    }
}

