/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.scope;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.myfaces.cdi.scope.FacesScopeBeanHolder;
import org.apache.myfaces.cdi.scope.FacesScoped;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;

@Typed
public class FacesScopedContextImpl
implements Context {
    private BeanManager beanManager;

    public FacesScopedContextImpl(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    protected FacesScopeBeanHolder getFacesScopeBeanHolder() {
        return this.getFacesScopeBeanHolder(FacesContext.getCurrentInstance());
    }

    protected FacesScopeBeanHolder getFacesScopeBeanHolder(FacesContext facesContext) {
        return new FacesScopeBeanHolder();
    }

    protected ContextualStorage getContextualStorage(boolean createIfNotExist, FacesContext facesContext) {
        if (facesContext == null) {
            throw new ContextNotActiveException("FacesScopedContextImpl: no current active facesContext");
        }
        if (createIfNotExist) {
            this.getFacesScopeBeanHolder(facesContext);
            return FacesScopeBeanHolder.getContextualStorage(this.beanManager, facesContext);
        }
        return this.getFacesScopeBeanHolder(facesContext).getContextualStorageNoCreate(this.beanManager, facesContext);
    }

    public Class<? extends Annotation> getScope() {
        return FacesScoped.class;
    }

    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        return facesContext != null;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (facesContext != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, facesContext);
            if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
        } else {
            throw new IllegalStateException("FacesContext cannot be found when resolving bean " + bean.toString());
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (!(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        ContextualStorage storage = this.getContextualStorage(true, facesContext);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    public boolean destroy(Contextual bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ContextualStorage storage = this.getContextualStorage(false, facesContext);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public static void destroyAllActive(ContextualStorage storage) {
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
            if ("oam.FACES_SCOPE_MAP_INFO".equals(entry.getKey())) continue;
            Contextual<?> bean = storage.getBean(entry.getKey());
            ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
            bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        }
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

