/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.html.HtmlPanelGroup;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlGroupRendererBase
extends HtmlRenderer {
    private static final String LAYOUT_BLOCK_VALUE = "block";

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map<String, List<ClientBehavior>> behaviors;
        ResponseWriter writer = context.getResponseWriter();
        boolean span = false;
        String layoutElement = "span";
        HtmlPanelGroup panelGroup = (HtmlPanelGroup)component;
        String layout = panelGroup.getLayout();
        if (layout != null && layout.equals(LAYOUT_BLOCK_VALUE)) {
            layoutElement = "div";
        }
        if ((behaviors = panelGroup.getClientBehaviors()) != null && !behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        }
        if (!behaviors.isEmpty() || this.shouldRenderId(context, component)) {
            span = true;
            writer.startElement(layoutElement, component);
            writer.writeAttribute("id", component.getClientId(context), null);
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(context)) {
                commonPropertiesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
                CommonHtmlAttributesUtil.renderCommonPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(context)) {
                CommonHtmlAttributesUtil.renderEventProperties(writer, commonPropertiesMarked, component);
            } else if (this.isCommonEventsOptimizationEnabled(context)) {
                CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(context, writer, commonPropertiesMarked, CommonHtmlEventsUtil.getMarkedEvents(component), component, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(context, writer, component, behaviors);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(context)) {
            long commonAttributesMarked = CommonHtmlAttributesUtil.getMarkedAttributes(component);
            if (commonAttributesMarked > 0L) {
                span = true;
                writer.startElement(layoutElement, component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, context);
                CommonHtmlAttributesUtil.renderCommonPassthroughProperties(writer, commonAttributesMarked, component);
            }
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, layoutElement, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
        RendererUtils.renderChildren(context, component);
        if (span) {
            writer.endElement(layoutElement);
        }
    }
}

