/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.io.IOException;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.WindowContextConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.config.JsfModuleConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.AfterPhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.BeforePhase;
import org.apache.myfaces.extensions.cdi.jsf.api.listener.phase.JsfPhaseId;
import org.apache.myfaces.extensions.cdi.jsf.api.request.RequestTypeResolver;
import org.apache.myfaces.extensions.cdi.jsf.impl.listener.request.FacesMessageEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableWindowContextManager;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;
import org.apache.myfaces.extensions.cdi.message.api.Message;

@ApplicationScoped
public class WindowContextManagerObserver {
    public static final String INITIAL_REDIRCT_PERFORMED_KEY = WindowContextManagerObserver.class.getName() + ":initial_redirect";

    protected void tryToRestoreWindowContext(@Observes @BeforePhase(value=JsfPhaseId.RESTORE_VIEW) PhaseEvent phaseEvent, EditableWindowContextManager windowContextManager, WindowHandler windowHandler, WindowContextConfig windowContextConfig) {
        ConversationUtils.tryToRestoreTheWindowIdEagerly(phaseEvent.getFacesContext(), windowContextManager, windowHandler, windowContextConfig);
    }

    protected void cleanup(@Observes @AfterPhase(value=JsfPhaseId.RESTORE_VIEW) PhaseEvent phaseEvent, RequestTypeResolver requestTypeResolver, EditableWindowContextManager windowContextManager, WindowContextConfig windowContextConfig, JsfModuleConfig jsfModuleConfig) {
        if (!requestTypeResolver.isPostRequest() && !requestTypeResolver.isPartialRequest()) {
            FacesContext facesContext = phaseEvent.getFacesContext();
            if (facesContext.getViewRoot() == null || facesContext.getViewRoot().getViewId() == null) {
                return;
            }
            boolean continueRequest = this.processGetRequest(facesContext, windowContextConfig, jsfModuleConfig);
            if (!continueRequest) {
                return;
            }
        }
        EditableWindowContext windowContext = (EditableWindowContext)windowContextManager.getCurrentWindowContext();
        ConversationUtils.storeCurrentViewIdAsNewViewId(phaseEvent.getFacesContext(), windowContext);
        this.tryToRestoreMessages(phaseEvent.getFacesContext(), windowContext, jsfModuleConfig);
        if (!requestTypeResolver.isPostRequest()) {
            return;
        }
        this.cleanupInactiveConversations(windowContext);
    }

    private void tryToRestoreMessages(FacesContext facesContext, EditableWindowContext windowContext, JsfModuleConfig jsfModuleConfig) {
        if (!jsfModuleConfig.isAlwaysKeepMessages()) {
            return;
        }
        List facesMessageEntryList = (List)windowContext.getAttribute(Message.class.getName(), List.class);
        if (facesMessageEntryList != null) {
            for (FacesMessageEntry facesMessageEntry : facesMessageEntryList) {
                facesContext.addMessage(facesMessageEntry.getComponentId(), facesMessageEntry.getFacesMessage());
                facesMessageEntryList.remove(facesMessageEntry);
            }
            facesMessageEntryList.clear();
        }
    }

    private boolean processGetRequest(FacesContext facesContext, WindowContextConfig windowContextConfig, JsfModuleConfig jsfModuleConfig) {
        boolean urlParameterSupported = windowContextConfig.isUrlParameterSupported();
        boolean useWindowIdForFirstPage = jsfModuleConfig.isInitialRedirectEnabled();
        if (!urlParameterSupported) {
            useWindowIdForFirstPage = false;
        }
        if (useWindowIdForFirstPage) {
            String windowId = (String)facesContext.getExternalContext().getRequestParameterMap().get("windowId");
            if ("automatedEntryPoint".equalsIgnoreCase(windowId)) {
                return true;
            }
            WindowHandler windowHandler = ConversationUtils.getWindowHandler();
            windowId = ConversationUtils.resolveWindowContextId(windowHandler, urlParameterSupported, windowContextConfig.isUnknownWindowIdsAllowed());
            if (windowId == null) {
                this.redirect(facesContext, windowHandler);
                return false;
            }
        }
        return true;
    }

    private void redirect(FacesContext facesContext, WindowHandler windowHandler) {
        if (facesContext.getResponseComplete()) {
            return;
        }
        facesContext.getExternalContext().getRequestMap().put(INITIAL_REDIRCT_PERFORMED_KEY, Boolean.TRUE);
        try {
            String targetURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
            windowHandler.sendRedirect(FacesContext.getCurrentInstance().getExternalContext(), targetURL, true);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private void cleanupInactiveConversations(EditableWindowContext windowContext) {
        for (EditableConversation conversation : windowContext.getConversations().values()) {
            if (conversation.isActive()) continue;
            conversation.close();
        }
        windowContext.removeInactiveConversations();
    }
}

