/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.annotation.Annotation;
import org.apache.myfaces.extensions.validator.baseval.annotation.SkipValidationSupport;
import org.apache.myfaces.extensions.validator.core.validation.EmptyValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.NullValueAwareValidationStrategy;
import org.apache.myfaces.extensions.validator.crossval.annotation.Equals;
import org.apache.myfaces.extensions.validator.crossval.annotation.MessageTarget;
import org.apache.myfaces.extensions.validator.crossval.parameter.CaseInsensitive;
import org.apache.myfaces.extensions.validator.crossval.strategy.AbstractCompareStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

@SkipValidationSupport
@NullValueAwareValidationStrategy
@EmptyValueAwareValidationStrategy
@UsageInformation(value={UsageCategory.INTERNAL})
public class EqualsStrategy
extends AbstractCompareStrategy {
    protected MessageTarget getMessageTarget(Annotation annotation) {
        return ((Equals)annotation).validationErrorMsgTarget();
    }

    protected String getValidationErrorMsgKey(Annotation annotation, boolean isTargetComponent) {
        return ((Equals)annotation).validationErrorMsgKey();
    }

    public boolean isViolation(Object object1, Object object2, Annotation annotation) {
        if (object1 instanceof String && object2 instanceof String && !this.isCaseSensitiveCompare(annotation)) {
            return !((String)object1).equalsIgnoreCase((String)object2);
        }
        return object1 != null && !object1.equals(object2);
    }

    public String[] getValidationTargets(Annotation annotation) {
        return ((Equals)annotation).value();
    }

    protected boolean isCaseSensitiveCompare(Annotation annotation) {
        return !ExtValUtils.getValidationParameterExtractor().extract(annotation, (Object)ExtValUtils.getValidationParameterClassFor(CaseInsensitive.class)).iterator().hasNext();
    }
}

