/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlInputText;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTextRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

public class HtmlTextRenderer
extends HtmlTextRendererBase {
    private static final String ONCHANGE_PREFIX = "onChange_";
    private static final String HIDDEN_SUFFIX = "_hidden";

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    protected boolean isDisabledOnClientSide(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabledOnClientSide();
        }
        return false;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            this.renderInputValueOnly(facesContext, component);
        } else {
            this.renderNormal(facesContext, component);
        }
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        if (!this.isDisabledOnClientSide(facesContext, component) || this.isDisabled(facesContext, component)) {
            super.renderInput(facesContext, component);
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        String value = RendererUtils.getStringValue(facesContext, component);
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        writer.writeAttribute("onchange", (Object)(this.getOnChangeFunctionName(clientId) + "();"), null);
        writer.endElement("input");
        this.renderHiddenInput(facesContext, (UIComponent)((UIInput)component));
    }

    protected void renderHiddenInput(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String disabledInputClientId = component.getClientId(facesContext);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)this.createOnChangeListenerJS(disabledInputClientId), null);
        writer.endElement("script");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(disabledInputClientId + HIDDEN_SUFFIX), null);
        writer.writeAttribute("name", (Object)(disabledInputClientId + HIDDEN_SUFFIX), null);
        writer.writeAttribute("value", (Object)RendererUtils.getStringValue(facesContext, component), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    protected void renderInputValueOnly(FacesContext facesContext, UIComponent component) throws IOException {
        HtmlRendererUtils.renderDisplayValueOnly(facesContext, (UIComponent)((UIInput)component));
    }

    protected void renderNormal(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
    }

    protected String getOnChangeFunctionName(String inputDisabledClientId) {
        StringBuffer buf = new StringBuffer();
        buf.append(ONCHANGE_PREFIX);
        buf.append(JavascriptUtils.getValidJavascriptName(inputDisabledClientId, true));
        return buf.toString();
    }

    protected String createOnChangeListenerJS(String inputDisabledClientId) {
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(this.getOnChangeFunctionName(inputDisabledClientId));
        script.append("() {\n");
        script.append("var hiddenInput = document.getElementById(\"").append(inputDisabledClientId + HIDDEN_SUFFIX).append("\");\n");
        script.append("var disabledInput = document.getElementById(\"").append(inputDisabledClientId).append("\");\n");
        script.append("hiddenInput.value=disabledInput.value;\n");
        script.append("}\n");
        return script.toString();
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (this.isDisabledOnClientSide(facesContext, component) && !this.isDisabled(facesContext, component)) {
            Map paramValuesMap = facesContext.getExternalContext().getRequestParameterMap();
            Object reqValue = paramValuesMap.get(component.getClientId(facesContext) + HIDDEN_SUFFIX);
            ((UIInput)component).setSubmittedValue(reqValue);
            return;
        }
        super.decode(facesContext, component);
    }
}

