/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class ExtensionsResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream stream = null;
    private PrintWriter printWriter = null;
    private String contentType;
    private HttpServletResponse delegate;
    private static final Log log = LogFactory.getLog((Class)ExtensionsResponseWrapper.class);

    public ExtensionsResponseWrapper(HttpServletResponse response) {
        super(response);
        this.delegate = response;
        this.stream = new ByteArrayOutputStream();
    }

    public byte[] getBytes() {
        return this.stream.toByteArray();
    }

    public String toString() {
        try {
            return this.stream.toString(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Response accepted invalid character encoding " + this.getCharacterEncoding());
        }
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)this.stream, Charset.forName(this.getCharacterEncoding()));
            this.printWriter = new PrintWriter((Writer)streamWriter, true);
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() {
        return new MyServletOutputStream(this.stream);
    }

    public InputSource getInputSource() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.stream.toByteArray());
        return new InputSource(bais);
    }

    public void setContentLength(int contentLength) {
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public void finishResponse() {
        try {
            if (this.printWriter != null) {
                this.printWriter.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public HttpServletResponse getDelegate() {
        return this.delegate;
    }

    private class MyServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream;

        public MyServletOutputStream(ByteArrayOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void write(int b) {
            this.outputStream.write(b);
        }

        public void write(byte[] bytes) throws IOException {
            this.outputStream.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            this.outputStream.write(bytes, off, len);
        }
    }
}

