/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.config.Configuration;
import org.apache.myfaces.trinidadinternal.share.config.ConfigurationImpl;
import org.apache.myfaces.trinidadinternal.share.expl.JavaMethod;
import org.apache.myfaces.trinidadinternal.share.io.CachingInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.DefaultNameResolver;
import org.apache.myfaces.trinidadinternal.share.xml.JaxpXMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextWrapper;
import org.apache.myfaces.trinidadinternal.share.xml.ParseErrorUtils;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static final String _SHARE_NAMESPACE = "http://myfaces.apache.org/uix/share";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XMLUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseInclude(ParseContext context, String sourceName, Class<?> expectedType) throws IOException, SAXException {
        NameResolver resolver = XMLUtils.getResolver(context);
        if (resolver == null) {
            XMLUtils._log(context, "Internal error: couldn't find NameResolver");
            return null;
        }
        InputStreamProvider provider = resolver.getProvider(sourceName);
        InputStreamProvider baseProvider = XMLUtils.getInputStreamProvider(context);
        if (baseProvider instanceof CachingInputStreamProvider) {
            ((CachingInputStreamProvider)baseProvider).addCacheDependency(provider);
        }
        ArrayList list = (ArrayList)context.getProperty(_SHARE_NAMESPACE, "_includeStack");
        Object identifier = provider.getIdentifier();
        if (list != null && list.contains(identifier)) {
            throw new SAXParseException(_LOG.getMessage("CIRCULAR_INCLUDE_DETECTED", (Object)sourceName), context.getLocator());
        }
        Object cached = provider.getCachedResult();
        if (cached != null && expectedType.isInstance(cached)) {
            return cached;
        }
        ParseContext newContext = (ParseContext)context.clone();
        list = list == null ? new ArrayList() : (ArrayList)list.clone();
        list.add(identifier);
        newContext.setProperty(_SHARE_NAMESPACE, "_includeStack", list);
        ParserManager parserManager = context.getParserManager();
        TreeBuilder builder = new TreeBuilder(parserManager, expectedType);
        try (InputStream stream = provider.openInputStream();){
            InputSource source = new InputSource(stream);
            source.setSystemId(sourceName);
            XMLUtils.setResolver(newContext, resolver.getResolver(sourceName));
            XMLUtils.setInputStreamProvider(newContext, provider);
            Object value = builder.parse(context.getXMLProvider(), source, newContext);
            if (value != null) {
                provider.setCachedResult(value);
            }
            Object object = value;
            return object;
        }
    }

    public static NameResolver getResolver(ParseContext context) {
        NameResolver source = (NameResolver)context.getProperty(_SHARE_NAMESPACE, "_nameResolver");
        if (source == null) {
            source = new DefaultNameResolver(null, null);
        }
        return source;
    }

    public static void setResolver(ParseContext context, NameResolver source) {
        context.setProperty(_SHARE_NAMESPACE, "_nameResolver", source);
    }

    public static InputStreamProvider getInputStreamProvider(ParseContext context) {
        return (InputStreamProvider)context.getProperty(_SHARE_NAMESPACE, "_provider");
    }

    public static void setInputStreamProvider(ParseContext context, InputStreamProvider provider) {
        context.setProperty(_SHARE_NAMESPACE, "_provider", provider);
    }

    public static void setXMLProvider(ConfigurationImpl config, String providerClassName) {
        config.putProperty(Configuration.XML_PROVIDER, providerClassName);
    }

    public static void setLocalProperty(ParseContext context, String namespace, Object key, Object value) {
        if (value != null) {
            value = new Object[]{context, value};
        }
        context.setProperty(namespace, key, value);
    }

    public static Object getLocalProperty(ParseContext context, String namespace, Object key) {
        ParseContext contextWhenSet;
        Object[] array;
        Object o = context.getProperty(namespace, key);
        if (o instanceof Object[] && (array = (Object[])o).length == 2 && array[0] instanceof ParseContext && XMLUtils._unwrapContext(contextWhenSet = (ParseContext)array[0]) == XMLUtils._unwrapContext(context)) {
            return array[1];
        }
        return null;
    }

    public static XMLProvider getXMLProvider(Configuration config) {
        return new JaxpXMLProvider();
    }

    public static String[] parseNameTokens(String stringValue) {
        List<String> list = XMLUtils.parseNameTokensAsList(stringValue);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static Set<String> parseNameTokensAsSet(String stringValue) {
        List<String> list = XMLUtils.parseNameTokensAsList(stringValue);
        if (list == null) {
            return null;
        }
        return new HashSet<String>(list);
    }

    public static List<String> parseNameTokensAsList(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(5);
        int length = stringValue.length();
        boolean inSpace = true;
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char ch = stringValue.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (inSpace) continue;
                list.add(stringValue.substring(start, i));
                inSpace = true;
                continue;
            }
            if (!inSpace) continue;
            start = i;
            inSpace = false;
        }
        if (!inSpace) {
            list.add(stringValue.substring(start));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static void registerFunctions(ParserManager manager, String namespace, Class<?> klass) {
        Method[] methods = klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method met = methods[i];
            int mod = met.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            manager.registerFunction(namespace, met.getName(), new JavaMethod(met));
        }
    }

    private static ParseContext _unwrapContext(ParseContext context) {
        if (context instanceof ParseContextWrapper) {
            context = ((ParseContextWrapper)context).__getWrappedContext();
        }
        return context;
    }

    private static void _log(ParseContext context, String message) {
        if (_LOG.isWarning()) {
            _LOG.warning(ParseErrorUtils.getErrorMessage(context, message));
        }
    }

    private XMLUtils() {
    }
}

