/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler;

import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoader;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceLoaderWrapper;
import org.apache.myfaces.commons.resourcehandler.resource.ResourceMeta;

/**
 * Resource Loader that just wraps ResourceMetaImpl into ExtendedResourceMetaImpl,
 * to allow cache request path expressions. 
 * 
 * @author Leonardo Uribe
 *
 */
public class ExtendedResourceLoaderWrapper extends ResourceLoaderWrapper
{
    private ResourceLoader _delegate;
    
    public ExtendedResourceLoaderWrapper(ResourceLoader delegate)
    {
        this._delegate = delegate; 
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName,
            String libraryVersion, String resourceName, String resourceVersion)
    {
        return new ExtendedResourceMetaImpl(
                super.createResourceMeta(prefix, libraryName, libraryVersion, 
                                         resourceName, resourceVersion));
    }

    public ResourceLoader getWrapped()
    {
        return _delegate;
    }
    
}
