/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.Trigger;

public class HintDescriptionFactory {
    private HintMetadata metadata;
    private Trigger trigger;
    private HintDescription.Worker worker;
    private HintDescription.AdditionalQueryConstraints additionalConstraints;
    private String hintText;
    private Set<HintMetadata.Options> options;
    private boolean finished;

    private HintDescriptionFactory() {
    }

    public static HintDescriptionFactory create() {
        return new HintDescriptionFactory();
    }

    public HintDescriptionFactory setMetadata(HintMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public HintDescriptionFactory setTriggerOptions(String[] triggerOpts) {
        this.trigger.setOptions(triggerOpts);
        return this;
    }

    public HintDescriptionFactory setTrigger(Trigger trigger) {
        if (this.trigger != null) {
            throw new IllegalStateException(this.trigger.toString());
        }
        this.trigger = trigger;
        return this;
    }

    public HintDescriptionFactory setWorker(HintDescription.Worker worker) {
        this.worker = worker;
        return this;
    }

    public HintDescriptionFactory setAdditionalConstraints(HintDescription.AdditionalQueryConstraints additionalConstraints) {
        this.additionalConstraints = additionalConstraints;
        return this;
    }

    public HintDescriptionFactory setHintText(@NonNull String hintText) {
        this.hintText = hintText;
        return this;
    }

    public HintDescriptionFactory addOptions(HintMetadata.Options ... options) {
        if (this.options == null) {
            this.options = EnumSet.noneOf(HintMetadata.Options.class);
        }
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    public HintDescription produce() {
        if (this.metadata == null) {
            this.metadata = HintMetadata.Builder.create("no-id").addOptions(HintMetadata.Options.NON_GUI).build();
        }
        if (this.additionalConstraints == null) {
            this.additionalConstraints = HintDescription.AdditionalQueryConstraints.empty();
        }
        return HintDescription.create(this.metadata, this.trigger, this.worker, this.additionalConstraints, this.hintText, this.options != null ? this.options : Collections.emptySet());
    }
}

