/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;

public final class IndexDocumentImpl
implements IndexDocument {
    static final String FIELD_PRIMARY_KEY = "_sn";
    final Document doc;

    public IndexDocumentImpl(String primaryKey) {
        assert (primaryKey != null);
        this.doc = new Document();
        this.doc.add(IndexDocumentImpl.sourceNameField(primaryKey));
    }

    public IndexDocumentImpl(Document doc) {
        assert (doc != null);
        this.doc = doc;
    }

    @Override
    public void addPair(String key, String value, boolean searchable, boolean stored) {
        Field field = new Field(key, value, stored ? Field.Store.YES : Field.Store.NO, searchable ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NO);
        this.doc.add(field);
    }

    @Override
    public String getValue(String key) {
        return this.doc.get(key);
    }

    @Override
    public String[] getValues(String key) {
        return this.doc.getValues(key);
    }

    @Override
    public String getPrimaryKey() {
        return this.doc.get(FIELD_PRIMARY_KEY);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "; " + this.getPrimaryKey();
    }

    private static Fieldable sourceNameField(String relativePath) {
        return new Field(FIELD_PRIMARY_KEY, relativePath, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    static Query sourceNameQuery(String relativePath) {
        return new TermQuery(IndexDocumentImpl.sourceNameTerm(relativePath));
    }

    static Term sourceNameTerm(String relativePath) {
        assert (relativePath != null);
        return new Term(FIELD_PRIMARY_KEY, relativePath);
    }
}

