<?php
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
class ConstructorPropertyPromotionWrong1 {

    private int $mandatory;
    public function __construct(
        private ?int $optional = 1,
        $mandatory, // test1
    ) {
        $this->mandatory = $mandatory;
    }

}

class ConstructorPropertyPromotionWrong2 {

    private int $mandatory;
    public function __construct(
        private ?int $optional1 = 1,
        $mandatory, // test2
        string $optional2 = "default value"
    ) {
        $this->mandatory = $mandatory;
    }

}

class ConstructorPropertyPromotionWrong3 {

    public function __construct(
        protected ?int $mandatory1,
        $optional = "default value",
        private string|int $mandatory2, // test3
    ) {
    }

}

class ConstructorPropertyPromotionWrong4 {

    public function __construct(
        private ?int $mandatory1,
        private $optional = "default value",
        public string $mandatory2 // test4
    ) {
    }

}

class ConstructorPropertyPromotionOK1 {

    public function __construct(
        private ?int $optional1 = 1,
        public $optional2 = [1, 2]
    ) {
    }

}

class ConstructorPropertyPromotionOK2 {

    public function __construct(
        $optional1 = 1,
        public $optional2 = [1, 2],
        private string $optional3 = "default value"
    ) {
    }

}

class ConstructorPropertyPromotionOK3 {

    public function __construct(
        private int $optional1 = 1,
        $optional2 = [1, 2],
        private string $optional1 = "default value"
    ) {
    }

}

class ConstructorPropertyPromotionOK4 {

    public function __construct(
        private int $optional1 = 1,
        protected $optional2 = [1, 2],
        private string $optional1 = "default value"
    ) {
    }

}
