/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.authorization.RequestAction;

public class AccessPolicy {
    private final String identifier;
    private final String resource;
    private final Set<String> users;
    private final Set<String> groups;
    private final RequestAction action;

    private AccessPolicy(Builder builder) {
        this.identifier = builder.identifier;
        this.resource = builder.resource;
        this.action = builder.action;
        this.users = Collections.unmodifiableSet(new HashSet(builder.users));
        this.groups = Collections.unmodifiableSet(new HashSet(builder.groups));
        if (this.identifier == null || this.identifier.trim().isEmpty()) {
            throw new IllegalArgumentException("Identifier can not be null or empty");
        }
        if (this.resource == null) {
            throw new IllegalArgumentException("Resource can not be null");
        }
        if (this.action == null) {
            throw new IllegalArgumentException("Action can not be null");
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResource() {
        return this.resource;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public RequestAction getAction() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPolicy other = (AccessPolicy)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    public int hashCode() {
        return Objects.hashCode(this.identifier);
    }

    public String toString() {
        return String.format("identifier[%s], resource[%s], users[%s], groups[%s], action[%s]", new Object[]{this.getIdentifier(), this.getResource(), this.getUsers(), this.getGroups(), this.getAction()});
    }

    public static class Builder {
        private String identifier;
        private String resource;
        private RequestAction action;
        private Set<String> users = new HashSet<String>();
        private Set<String> groups = new HashSet<String>();
        private final boolean fromPolicy;

        public Builder() {
            this.fromPolicy = false;
        }

        public Builder(AccessPolicy other) {
            if (other == null) {
                throw new IllegalArgumentException("Can not initialize builder with a null access policy");
            }
            this.identifier = other.getIdentifier();
            this.resource = other.getResource();
            this.action = other.getAction();
            this.users.clear();
            this.users.addAll(other.getUsers());
            this.groups.clear();
            this.groups.addAll(other.getGroups());
            this.fromPolicy = true;
        }

        public Builder identifier(String identifier) {
            if (this.fromPolicy) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing policy");
            }
            this.identifier = identifier;
            return this;
        }

        public Builder identifierGenerateRandom() {
            if (this.fromPolicy) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing policy");
            }
            this.identifier = UUID.randomUUID().toString();
            return this;
        }

        public Builder identifierGenerateFromSeed(String seed) {
            if (this.fromPolicy) {
                throw new IllegalStateException("Identifier can not be changed when initialized from an existing policy");
            }
            if (seed == null) {
                throw new IllegalArgumentException("Cannot seed the policy identifier with a null value.");
            }
            this.identifier = UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).toString();
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder addUsers(Set<String> users) {
            if (users != null) {
                this.users.addAll(users);
            }
            return this;
        }

        public Builder addUser(String user) {
            if (user != null) {
                this.users.add(user);
            }
            return this;
        }

        public Builder removeUsers(Set<String> users) {
            if (users != null) {
                this.users.removeAll(users);
            }
            return this;
        }

        public Builder removeUser(String user) {
            if (user != null) {
                this.users.remove(user);
            }
            return this;
        }

        public Builder clearUsers() {
            this.users.clear();
            return this;
        }

        public Builder addGroups(Set<String> groups) {
            if (groups != null) {
                this.groups.addAll(groups);
            }
            return this;
        }

        public Builder addGroup(String group) {
            if (group != null) {
                this.groups.add(group);
            }
            return this;
        }

        public Builder removeGroups(Set<String> groups) {
            if (groups != null) {
                this.groups.removeAll(groups);
            }
            return this;
        }

        public Builder removeGroup(String group) {
            if (group != null) {
                this.groups.remove(group);
            }
            return this;
        }

        public Builder clearGroups() {
            this.groups.clear();
            return this;
        }

        public Builder action(RequestAction action) {
            this.action = action;
            return this;
        }

        public AccessPolicy build() {
            return new AccessPolicy(this);
        }
    }
}

