/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.kafka.connect.StatelessKafkaConnectorUtil;
import org.apache.nifi.kafka.connect.StatelessNiFiSinkConfig;
import org.apache.nifi.stateless.flow.DataflowTrigger;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StatelessNiFiSinkTask
extends SinkTask {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFiSinkTask.class);
    private StatelessDataflow dataflow;
    private String inputPortName;
    private Set<String> failurePortNames;
    private long timeoutMillis;
    private Pattern headerNameRegex;
    private String headerNamePrefix;
    private QueueSize queueSize;
    private String dataflowName;
    private long backoffMillis = 0L;

    public String version() {
        return StatelessKafkaConnectorUtil.getVersion();
    }

    public void start(Map<String, String> properties) {
        logger.info("Starting Sink Task");
        StatelessNiFiSinkConfig config = this.createConfig(properties);
        String timeout = config.getDataflowTimeout();
        this.timeoutMillis = (long)FormatUtils.getPreciseTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        this.dataflowName = config.getDataflowName();
        String regex = config.getHeadersAsAttributesRegex();
        this.headerNameRegex = regex == null ? null : Pattern.compile(regex);
        this.headerNamePrefix = config.getHeaderAttributeNamePrefix();
        if (this.headerNamePrefix == null) {
            this.headerNamePrefix = "";
        }
        this.dataflow = StatelessKafkaConnectorUtil.createDataflow(config);
        this.dataflow.initialize();
        this.inputPortName = config.getInputPortName();
        if (this.inputPortName == null) {
            Set inputPorts = this.dataflow.getInputPortNames();
            if (inputPorts.isEmpty()) {
                throw new ConfigException("The dataflow specified for <" + this.dataflowName + "> does not have an Input Port at the root level. Dataflows used for a Kafka Connect Sink Task must have at least one Input Port at the root level.");
            }
            if (inputPorts.size() > 1) {
                throw new ConfigException("The dataflow specified for <" + this.dataflowName + "> has multiple Input Ports at the root level (" + inputPorts + "). The " + "input.port" + " property must be set to indicate which of these Ports Kafka records should be sent to.");
            }
            this.inputPortName = (String)inputPorts.iterator().next();
        }
        if (!this.dataflow.getInputPortNames().contains(this.inputPortName)) {
            throw new ConfigException("The dataflow specified for <" + this.dataflowName + "> does not have Input Port with name <" + this.inputPortName + "> at the root level. Existing Input Port names are " + this.dataflow.getInputPortNames());
        }
        this.failurePortNames = config.getFailurePorts();
        Set outputPortNames = this.dataflow.getOutputPortNames();
        for (String failurePortName : this.failurePortNames) {
            if (outputPortNames.contains(failurePortName)) continue;
            throw new ConfigException("Dataflow was configured with a Failure Port of " + failurePortName + " but there is no Port with that name in the dataflow. Valid Port names are " + outputPortNames);
        }
    }

    public void put(Collection<SinkRecord> records) {
        logger.debug("Enqueuing {} Kafka messages", (Object)records.size());
        for (SinkRecord record : records) {
            Map<String, String> attributes = this.createAttributes(record);
            byte[] contents = this.getContents(record.value());
            this.queueSize = this.dataflow.enqueue(contents, attributes, this.inputPortName);
        }
    }

    protected StatelessNiFiSinkConfig createConfig(Map<String, String> properties) {
        return new StatelessNiFiSinkConfig(properties);
    }

    private void backoff() {
        if (this.backoffMillis == 0L) {
            this.backoffMillis = 1000L;
        }
        this.backoffMillis = Math.min(this.backoffMillis * 2L, 10000L);
        this.context.timeout(this.backoffMillis);
    }

    private void resetBackoff() {
        this.backoffMillis = 0L;
    }

    private synchronized void triggerDataflow() {
        long start = System.nanoTime();
        while (this.dataflow.isFlowFileQueued()) {
            DataflowTrigger trigger = this.dataflow.trigger();
            try {
                Optional resultOptional = trigger.getResult(this.timeoutMillis, TimeUnit.MILLISECONDS);
                if (resultOptional.isPresent()) {
                    TriggerResult result = (TriggerResult)resultOptional.get();
                    if (result.isSuccessful()) {
                        this.verifyOutputPortContents(trigger, result);
                        result.acknowledge();
                        this.resetBackoff();
                        continue;
                    }
                    this.retry(trigger, "Dataflow " + this.dataflowName + " failed to execute properly", result.getFailureCause().orElse(null));
                    continue;
                }
                this.retry(trigger, "Timed out waiting for dataflow " + this.dataflowName + " to complete", null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.dataflow.purge();
                throw new RuntimeException("Interrupted while waiting for dataflow to complete", e);
            }
        }
        this.context.requestCommit();
        long nanos = System.nanoTime() - start;
        if (this.queueSize != null) {
            logger.debug("Ran dataflow with {} messages ({}) in {} nanos", new Object[]{this.queueSize.getObjectCount(), FormatUtils.formatDataSize((double)this.queueSize.getByteCount()), nanos});
        }
    }

    private void retry(DataflowTrigger trigger, String explanation, Throwable cause) {
        logger.error(explanation, cause);
        trigger.cancel();
        this.backoff();
        this.dataflow.purge();
        throw new RetriableException(explanation, cause);
    }

    private void verifyOutputPortContents(DataflowTrigger trigger, TriggerResult result) {
        for (String failurePort : this.failurePortNames) {
            List flowFiles = result.getOutputFlowFiles(failurePort);
            if (flowFiles == null || flowFiles.isEmpty()) continue;
            logger.error("Dataflow transferred FlowFiles to Port {}, which is configured as a Failure Port. Rolling back session.", (Object)failurePort);
            trigger.cancel();
            throw new RetriableException("Data was transferred to Failure Port " + failurePort);
        }
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        super.flush(currentOffsets);
        this.triggerDataflow();
    }

    private byte[] getContents(Object value) {
        if (value == null) {
            return new byte[0];
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new IllegalArgumentException("Unsupported message type: the Message value was " + value + " but was expected to be a byte array or a String");
    }

    private Map<String, String> createAttributes(SinkRecord record) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("kafka.topic", record.topic());
        attributes.put("kafka.offset", String.valueOf(record.kafkaOffset()));
        attributes.put("kafka.partition", String.valueOf(record.kafkaPartition()));
        attributes.put("kafka.timestamp", String.valueOf(record.timestamp()));
        Object key = record.key();
        if (key instanceof String) {
            attributes.put("kafka.key", (String)key);
        }
        if (this.headerNameRegex != null) {
            for (Header header : record.headers()) {
                if (!this.headerNameRegex.matcher(header.key()).matches()) continue;
                String attributeName = this.headerNamePrefix + header.key();
                String attributeValue = String.valueOf(header.value());
                attributes.put(attributeName, attributeValue);
            }
        }
        return attributes;
    }

    public void stop() {
        logger.info("Shutting down Sink Task");
        if (this.dataflow != null) {
            this.dataflow.shutdown();
        }
    }
}

