/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental.schemahistory;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.extensibility.MigrationType;

public class SchemaHistoryModel {
    private final List<SchemaHistoryItem> schemaHistoryItems;

    public SchemaHistoryModel() {
        this(List.of());
    }

    public List<SchemaHistoryItem> getSchemaHistoryItems() {
        return Collections.unmodifiableList(this.schemaHistoryItems);
    }

    public int calculateInstalledRank(MigrationType type) {
        if (this.schemaHistoryItems.isEmpty()) {
            return type == CoreMigrationType.SCHEMA ? 0 : 1;
        }
        return this.schemaHistoryItems.stream().map(SchemaHistoryItem::getInstalledRank).max(Integer::compareTo).orElse(0) + 1;
    }

    public MigrationVersion getInitialVersion() {
        return this.schemaHistoryItems.stream().map(SchemaHistoryItem::getVersion).filter(Objects::nonNull).map(MigrationVersion::fromVersion).max(MigrationVersion::compareTo).orElse(MigrationVersion.EMPTY);
    }

    public SchemaHistoryModel(List<SchemaHistoryItem> schemaHistoryItems) {
        this.schemaHistoryItems = schemaHistoryItems;
    }
}

