/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ControllerClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ControllerConfigurationResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;

public class UpdateControllerConfiguration
extends AbstractNiFiCommand<ControllerConfigurationResult> {
    public UpdateControllerConfiguration() {
        super("update-controller-configuration", ControllerConfigurationResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates controller configuration from a local file.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public ControllerConfigurationResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
        String contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        ControllerConfigurationEntity controllerConfiguration = (ControllerConfigurationEntity)objectMapper.readValue(contents, ControllerConfigurationEntity.class);
        if (controllerConfiguration == null || controllerConfiguration.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        ControllerClient controllerClient = client.getControllerClient();
        RevisionDTO revisionDTO = client.getControllerClient().getControllerConfiguration().getRevision();
        controllerConfiguration.setRevision(revisionDTO);
        ControllerConfigurationEntity createdEntity = controllerClient.updateControllerConfiguration(controllerConfiguration);
        return new ControllerConfigurationResult(this.getResultType(properties), createdEntity);
    }
}

