/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api.jpql;

import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;

public class JPQLStatement {
    protected String statement;

    public static JPQLStatementBuilder createBuilder(JPQLContextView context) throws ODataJPARuntimeException {
        return JPQLStatementBuilder.create(context);
    }

    private JPQLStatement(String statement) {
        this.statement = statement;
    }

    public String toString() {
        return this.statement;
    }

    public static final class DELIMITER {
        public static final char SPACE = ' ';
        public static final char COMMA = ',';
        public static final char PERIOD = '.';
        public static final char PARENTHESIS_LEFT = '(';
        public static final char PARENTHESIS_RIGHT = ')';
        public static final char COLON = ':';
        public static final char HYPHEN = '-';
        public static final char LEFT_BRACE = '{';
        public static final char RIGHT_BRACE = '}';
        public static final char LONG = 'L';
    }

    public static final class KEYWORD {
        public static final String SELECT = "SELECT";
        public static final String SELECT_DISTINCT = "SELECT DISTINCT";
        public static final String FROM = "FROM";
        public static final String WHERE = "WHERE";
        public static final String LEFT_OUTER_JOIN = "LEFT OUTER JOIN";
        public static final String OUTER = "OUTER";
        public static final String JOIN = "JOIN";
        public static final String ORDERBY = "ORDER BY";
        public static final String COUNT = "COUNT";
        public static final String OFFSET = ".000";
        public static final String TIMESTAMP = "ts";
    }

    public static final class Operator {
        public static final String EQ = "=";
        public static final String NE = "<>";
        public static final String LT = "<";
        public static final String LE = "<=";
        public static final String GT = ">";
        public static final String GE = ">=";
        public static final String AND = "AND";
        public static final String NOT = "NOT";
        public static final String OR = "OR";
        public static final String LIKE = "LIKE";
    }

    public static abstract class JPQLStatementBuilder {
        protected JPQLStatementBuilder() {
        }

        private static final JPQLStatementBuilder create(JPQLContextView context) throws ODataJPARuntimeException {
            return ODataJPAFactory.createFactory().getJPQLBuilderFactory().getStatementBuilder(context);
        }

        protected final JPQLStatement createStatement(String statement) {
            return new JPQLStatement(statement);
        }

        public abstract JPQLStatement build() throws ODataJPARuntimeException;
    }
}

