/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.exception.ODataRuntimeApplicationException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.ProviderFacadeImpl;
import org.apache.olingo.odata2.core.exception.MessageService;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class ODataExceptionWrapper {
    private static final String DOLLAR_FORMAT = "$format";
    private static final String DOLLAR_FORMAT_JSON = "json";
    private static final Locale DEFAULT_RESPONSE_LOCALE = Locale.ENGLISH;
    private String contentType;
    private URI requestUri;
    private final Locale messageLocale;
    private final Map<String, List<String>> httpRequestHeaders;
    private final ODataErrorCallback callback;
    private final ODataErrorContext errorContext = new ODataErrorContext();

    public ODataExceptionWrapper(ODataContext context, Map<String, String> queryParameters, List<String> acceptHeaderContentTypes) {
        this.contentType = this.getContentType(queryParameters, acceptHeaderContentTypes).toContentTypeString();
        this.messageLocale = MessageService.getSupportedLocale(this.getLanguages(context), DEFAULT_RESPONSE_LOCALE);
        this.httpRequestHeaders = context.getRequestHeaders();
        try {
            this.requestUri = context.getPathInfo().getRequestUri();
            this.errorContext.setPathInfo(context.getPathInfo());
            this.callback = this.getErrorHandlerCallbackFromContext(context);
        }
        catch (Exception e) {
            throw new ODataRuntimeException("Exception occurred", e);
        }
    }

    public ODataExceptionWrapper(UriInfo uriInfo, HttpHeaders httpHeaders, ODataErrorCallback errorCallback) {
        try {
            this.contentType = this.getContentType(uriInfo, httpHeaders).toContentTypeString();
            this.requestUri = uriInfo != null ? uriInfo.getRequestUri() : null;
        }
        catch (IllegalArgumentException e) {
            this.contentType = null;
            this.requestUri = null;
        }
        this.messageLocale = MessageService.getSupportedLocale(this.getLanguages(httpHeaders), DEFAULT_RESPONSE_LOCALE);
        this.httpRequestHeaders = httpHeaders.getRequestHeaders();
        this.callback = errorCallback;
    }

    public ODataResponse wrapInExceptionResponse(Exception exception) {
        try {
            Exception toHandleException = this.extractException(exception);
            this.fillErrorContext(toHandleException);
            if (toHandleException instanceof ODataApplicationException) {
                this.enhanceContextWithApplicationException((ODataApplicationException)((Object)toHandleException));
            } else if (toHandleException instanceof ODataRuntimeApplicationException) {
                this.enhanceContextWithRuntimeApplicationException((ODataRuntimeApplicationException)toHandleException);
            } else if (toHandleException instanceof ODataMessageException) {
                this.enhanceContextWithMessageException((ODataMessageException)toHandleException);
            }
            ODataResponse oDataResponse = this.callback != null ? this.handleErrorCallback(this.callback) : EntityProvider.writeErrorDocument((ODataErrorContext)this.errorContext);
            if (!oDataResponse.containsHeader("Content-Type")) {
                oDataResponse = ODataResponse.fromResponse((ODataResponse)oDataResponse).contentHeader(this.contentType).build();
            }
            return oDataResponse;
        }
        catch (Exception e) {
            ODataResponse response = ODataResponse.entity((Object)"Exception during error handling occured!").contentHeader(ContentType.TEXT_PLAIN.toContentTypeString()).status(HttpStatusCodes.INTERNAL_SERVER_ERROR).build();
            return response;
        }
    }

    private void enhanceContextWithRuntimeApplicationException(ODataRuntimeApplicationException toHandleException) {
        this.errorContext.setHttpStatus(toHandleException.getHttpStatus());
        this.errorContext.setErrorCode(toHandleException.getCode());
    }

    private ODataResponse handleErrorCallback(ODataErrorCallback callback) throws EntityProviderException {
        ODataResponse oDataResponse;
        try {
            oDataResponse = callback.handleError(this.errorContext);
        }
        catch (ODataApplicationException e) {
            this.fillErrorContext((Exception)((Object)e));
            this.enhanceContextWithApplicationException(e);
            oDataResponse = new ProviderFacadeImpl().writeErrorDocument(this.errorContext);
        }
        return oDataResponse;
    }

    private void enhanceContextWithApplicationException(ODataApplicationException toHandleException) {
        this.errorContext.setHttpStatus(toHandleException.getHttpStatus());
        this.errorContext.setErrorCode(toHandleException.getCode());
        this.errorContext.setLocale(this.messageLocale);
    }

    private void enhanceContextWithMessageException(ODataMessageException toHandleException) {
        MessageService.Message localizedMessage;
        this.errorContext.setErrorCode(toHandleException.getErrorCode());
        MessageReference messageReference = toHandleException.getMessageReference();
        MessageService.Message message = localizedMessage = messageReference == null ? null : this.extractEntity(messageReference);
        if (localizedMessage != null) {
            this.errorContext.setMessage(localizedMessage.getText());
            this.errorContext.setLocale(localizedMessage.getLocale());
        }
        if (toHandleException instanceof ODataHttpException) {
            this.errorContext.setHttpStatus(((ODataHttpException)toHandleException).getHttpStatus());
        } else if (toHandleException instanceof EntityProviderException) {
            if (toHandleException instanceof EntityProviderProducerException) {
                this.errorContext.setHttpStatus(HttpStatusCodes.INTERNAL_SERVER_ERROR);
            } else {
                this.errorContext.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
            }
        } else if (toHandleException instanceof BatchException) {
            this.errorContext.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
        }
    }

    private void fillErrorContext(Exception exception) {
        if (this.contentType != null || this.requestUri != null) {
            this.errorContext.setContentType(this.contentType);
            this.errorContext.setRequestUri(this.requestUri);
            this.errorContext.setHttpStatus(HttpStatusCodes.INTERNAL_SERVER_ERROR);
        } else {
            this.errorContext.setContentType(ContentType.APPLICATION_ATOM_XML.toContentTypeString());
            this.errorContext.setRequestUri(null);
            this.errorContext.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
        }
        this.errorContext.setException(exception);
        this.errorContext.setErrorCode(null);
        this.errorContext.setMessage(exception.getMessage());
        this.errorContext.setLocale(DEFAULT_RESPONSE_LOCALE);
        if (this.httpRequestHeaders != null) {
            for (Map.Entry<String, List<String>> entry : this.httpRequestHeaders.entrySet()) {
                this.errorContext.putRequestHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private Exception extractException(Exception exception) {
        if (exception instanceof ODataException) {
            ODataException odataException = (ODataException)((Object)exception);
            if (odataException.isCausedByApplicationException()) {
                return odataException.getApplicationExceptionCause();
            }
            if (odataException.isCausedByHttpException()) {
                return odataException.getHttpExceptionCause();
            }
            if (odataException.isCausedByMessageException()) {
                return odataException.getMessageExceptionCause();
            }
        }
        return exception;
    }

    private MessageService.Message extractEntity(MessageReference context) {
        return MessageService.getMessage(this.messageLocale, context);
    }

    private List<Locale> getLanguages(ODataContext context) {
        try {
            if (context.getAcceptableLanguages().isEmpty()) {
                return Arrays.asList(DEFAULT_RESPONSE_LOCALE);
            }
            return context.getAcceptableLanguages();
        }
        catch (WebApplicationException e) {
            if (e.getCause() != null && e.getCause().getClass() == ParseException.class) {
                return Arrays.asList(DEFAULT_RESPONSE_LOCALE);
            }
            throw e;
        }
    }

    private List<Locale> getLanguages(HttpHeaders httpHeaders) {
        try {
            if (httpHeaders.getAcceptableLanguages().isEmpty()) {
                return Arrays.asList(DEFAULT_RESPONSE_LOCALE);
            }
            return httpHeaders.getAcceptableLanguages();
        }
        catch (WebApplicationException e) {
            if (e.getCause() != null && e.getCause().getClass() == ParseException.class) {
                return Arrays.asList(DEFAULT_RESPONSE_LOCALE);
            }
            throw e;
        }
    }

    private ContentType getContentType(Map<String, String> queryParameters, List<String> acceptHeaderContentTypes) {
        ContentType cntType = this.getContentTypeByUriInfo(queryParameters);
        if (cntType == null) {
            cntType = this.getContentTypeByAcceptHeader(acceptHeaderContentTypes);
        }
        return cntType;
    }

    private ContentType getContentTypeByUriInfo(Map<String, String> queryParameters) {
        ContentType cntType = null;
        if (queryParameters != null && queryParameters.containsKey(DOLLAR_FORMAT)) {
            String contentTypeString = queryParameters.get(DOLLAR_FORMAT);
            cntType = DOLLAR_FORMAT_JSON.equals(contentTypeString) ? ContentType.APPLICATION_JSON : ContentType.APPLICATION_XML;
        }
        return cntType;
    }

    private ContentType getContentTypeByAcceptHeader(List<String> acceptHeaderContentTypes) {
        for (String acceptContentType : acceptHeaderContentTypes) {
            if (!ContentType.isParseable(acceptContentType)) continue;
            ContentType convertedContentType = ContentType.create(acceptContentType);
            if (convertedContentType.isWildcard() || ContentType.APPLICATION_XML.equals(convertedContentType) || ContentType.APPLICATION_XML_CS_UTF_8.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML_CS_UTF_8.equals(convertedContentType)) {
                return ContentType.APPLICATION_XML;
            }
            if (!ContentType.APPLICATION_JSON.equals(convertedContentType) && !ContentType.APPLICATION_JSON_CS_UTF_8.equals(convertedContentType) && !ContentType.APPLICATION_JSON_ODATA_VERBOSE.equals(convertedContentType)) continue;
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_XML;
    }

    private ContentType getContentType(UriInfo uriInfo, HttpHeaders httpHeaders) {
        ContentType cntType = this.getContentTypeByUriInfo(uriInfo);
        if (cntType == null) {
            cntType = this.getContentTypeByAcceptHeader(httpHeaders);
        }
        return cntType;
    }

    private ContentType getContentTypeByUriInfo(UriInfo uriInfo) {
        MultivaluedMap queryParameters;
        ContentType cntType = null;
        if (uriInfo != null && uriInfo.getQueryParameters() != null && (queryParameters = uriInfo.getQueryParameters()).containsKey((Object)DOLLAR_FORMAT)) {
            String contentTypeString = (String)queryParameters.getFirst((Object)DOLLAR_FORMAT);
            cntType = DOLLAR_FORMAT_JSON.equals(contentTypeString) ? ContentType.APPLICATION_JSON : ContentType.APPLICATION_XML;
        }
        return cntType;
    }

    private ContentType getContentTypeByAcceptHeader(HttpHeaders httpHeaders) {
        for (MediaType type : httpHeaders.getAcceptableMediaTypes()) {
            if (!ContentType.isParseable(type.toString())) continue;
            ContentType convertedContentType = ContentType.create(type.toString());
            if (convertedContentType.isWildcard() || ContentType.APPLICATION_XML.equals(convertedContentType) || ContentType.APPLICATION_XML_CS_UTF_8.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML_CS_UTF_8.equals(convertedContentType)) {
                return ContentType.APPLICATION_XML;
            }
            if (!ContentType.APPLICATION_JSON.equals(convertedContentType) && !ContentType.APPLICATION_JSON_CS_UTF_8.equals(convertedContentType) && !ContentType.APPLICATION_JSON_ODATA_VERBOSE.equals(convertedContentType)) continue;
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_XML;
    }

    private ODataErrorCallback getErrorHandlerCallbackFromContext(ODataContext context) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ODataErrorCallback cback = null;
        ODataServiceFactory serviceFactory = context.getServiceFactory();
        cback = (ODataErrorCallback)serviceFactory.getCallback(ODataErrorCallback.class);
        return cback;
    }
}

