/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.SpringBootExceptionReporter;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;

final class FailureAnalyzers
implements SpringBootExceptionReporter {
    private static final Log logger = LogFactory.getLog(FailureAnalyzers.class);
    private final SpringFactoriesLoader springFactoriesLoader;
    private final List<FailureAnalyzer> analyzers;

    public FailureAnalyzers(ConfigurableApplicationContext context) {
        this(context, SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)(context != null ? context.getClassLoader() : null)));
    }

    FailureAnalyzers(ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        this.springFactoriesLoader = springFactoriesLoader;
        this.analyzers = FailureAnalyzers.loadFailureAnalyzers(context, this.springFactoriesLoader);
    }

    private static List<FailureAnalyzer> loadFailureAnalyzers(ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        List analyzers = springFactoriesLoader.load(FailureAnalyzer.class, FailureAnalyzers.getArgumentResolver(context), SpringFactoriesLoader.FailureHandler.logging((Log)logger));
        List<FailureAnalyzer> awareAnalyzers = analyzers.stream().filter(analyzer -> analyzer instanceof BeanFactoryAware || analyzer instanceof EnvironmentAware).toList();
        if (!awareAnalyzers.isEmpty()) {
            String awareAnalyzerNames = StringUtils.collectionToCommaDelimitedString(awareAnalyzers.stream().map(analyzer -> analyzer.getClass().getName()).toList());
            logger.warn((Object)LogMessage.format((String)"FailureAnalyzers [%s] implement BeanFactoryAware or EnvironmentAware. Support for these interfaces on FailureAnalyzers is deprecated, and will be removed in a future release. Instead provide a constructor that accepts BeanFactory or Environment parameters.", (Object)awareAnalyzerNames));
            if (context == null) {
                logger.trace((Object)LogMessage.format((String)"Skipping [%s] due to missing context", (Object)awareAnalyzerNames));
                return analyzers.stream().filter(analyzer -> !awareAnalyzers.contains(analyzer)).toList();
            }
            awareAnalyzers.forEach(analyzer -> {
                if (analyzer instanceof BeanFactoryAware) {
                    BeanFactoryAware beanFactoryAware = (BeanFactoryAware)analyzer;
                    beanFactoryAware.setBeanFactory((BeanFactory)context.getBeanFactory());
                }
                if (analyzer instanceof EnvironmentAware) {
                    EnvironmentAware environmentAware = (EnvironmentAware)analyzer;
                    environmentAware.setEnvironment((Environment)context.getEnvironment());
                }
            });
        }
        return analyzers;
    }

    private static SpringFactoriesLoader.ArgumentResolver getArgumentResolver(ConfigurableApplicationContext context) {
        if (context == null) {
            return null;
        }
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(BeanFactory.class, (Object)context.getBeanFactory());
        argumentResolver = argumentResolver.and(Environment.class, (Object)context.getEnvironment());
        return argumentResolver;
    }

    @Override
    public boolean reportException(Throwable failure) {
        FailureAnalysis analysis = this.analyze(failure, this.analyzers);
        return this.report(analysis);
    }

    private FailureAnalysis analyze(Throwable failure, List<FailureAnalyzer> analyzers) {
        for (FailureAnalyzer analyzer : analyzers) {
            try {
                FailureAnalysis analysis = analyzer.analyze(failure);
                if (analysis == null) continue;
                return analysis;
            }
            catch (Throwable ex) {
                logger.trace((Object)LogMessage.format((String)"FailureAnalyzer %s failed", (Object)analyzer), ex);
            }
        }
        return null;
    }

    private boolean report(FailureAnalysis analysis) {
        List reporters = this.springFactoriesLoader.load(FailureAnalysisReporter.class);
        if (analysis == null || reporters.isEmpty()) {
            return false;
        }
        for (FailureAnalysisReporter reporter : reporters) {
            reporter.report(analysis);
        }
        return true;
    }
}

