/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.olingo.odata2.api.edm.EdmElement;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class ODataExpressionParser {
    public static final String EMPTY = "";
    public static final ThreadLocal<Integer> methodFlag = new ThreadLocal();
    public static final Character[] EMPTY_CHARACTER_ARRAY = new Character[0];
    public static final ThreadLocal<Map<Integer, Object>> positionalParameters = new ThreadLocal();

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias) throws ODataException {
        EdmMapping edmMapping = null;
        return ODataExpressionParser.parseToJPAWhereExpression(whereExpression, tableAlias, 1, new ConcurrentHashMap<Integer, Object>(), edmMapping);
    }

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias, int index, Map<Integer, Object> positionalParameters, EdmMapping edmMapping) throws ODataException {
        switch (whereExpression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)whereExpression;
                String operand = ODataExpressionParser.parseToJPAWhereExpression(unaryExpression.getOperand(), tableAlias, index, positionalParameters, edmMapping);
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return "NOT(" + operand + ")";
                    }
                    case MINUS: {
                        if (operand.startsWith("-")) {
                            return operand.substring(1);
                        }
                        return "-" + operand;
                    }
                }
                throw new ODataNotImplementedException();
            }
            case FILTER: {
                return ODataExpressionParser.parseToJPAWhereExpression(((FilterExpression)whereExpression).getExpression(), tableAlias, index, positionalParameters, edmMapping);
            }
            case BINARY: {
                BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
                MethodOperator operator = null;
                if (binaryExpression.getLeftOperand().getKind() == ExpressionKind.METHOD) {
                    operator = ((MethodExpression)binaryExpression.getLeftOperand()).getMethod();
                }
                if (operator != null && (binaryExpression.getOperator() == BinaryOperator.EQ || binaryExpression.getOperator() == BinaryOperator.NE) && operator == MethodOperator.SUBSTRINGOF) {
                    methodFlag.set(1);
                }
                String left = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getLeftOperand(), tableAlias, ODataExpressionParser.getIndexValue(index, positionalParameters), positionalParameters, edmMapping);
                edmMapping = ODataExpressionParser.getEdmMapping(binaryExpression);
                String right = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getRightOperand(), tableAlias, ODataExpressionParser.getIndexValue(index, positionalParameters), positionalParameters, edmMapping);
                if (operator != null && (operator == MethodOperator.STARTSWITH || operator == MethodOperator.ENDSWITH)) {
                    if (!binaryExpression.getOperator().equals((Object)BinaryOperator.EQ) && !(binaryExpression.getRightOperand() instanceof LiteralExpression) && ("true".equals(right) || "false".equals(right))) {
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.OPERATOR_EQ_NE_MISSING.addContent(new Object[]{binaryExpression.getOperator().toString()}), null);
                    }
                    if (binaryExpression.getOperator().equals((Object)BinaryOperator.EQ)) {
                        if ("false".equals(right)) {
                            return "(" + left.replaceFirst("LIKE", "NOT LIKE") + " )";
                        }
                        if ("true".equals(right)) {
                            return "(" + left + " )";
                        }
                    }
                }
                switch (binaryExpression.getOperator()) {
                    case AND: {
                        return "(" + left + " AND " + right + ")";
                    }
                    case OR: {
                        return "(" + left + " OR " + right + ")";
                    }
                    case EQ: {
                        EdmSimpleType type = (EdmSimpleType)((BinaryExpression)whereExpression).getLeftOperand().getEdmType();
                        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(type) && (edmMapping == null || edmMapping != null && !((JPAEdmMappingImpl)edmMapping).getJPAType().isEnum())) {
                            return "(" + left + " " + (!"null".equals(right) ? "LIKE" : "IS") + " " + right + ("null".equals(right) ? EMPTY : " ESCAPE '\\'") + ")";
                        }
                        return "(" + left + " " + (!"null".equals(right) ? "=" : "IS") + " " + right + ")";
                    }
                    case NE: {
                        EdmSimpleType edmType = (EdmSimpleType)((BinaryExpression)whereExpression).getLeftOperand().getEdmType();
                        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(edmType)) {
                            return "(" + left + " " + (!"null".equals(right) ? "NOT LIKE" : "IS NOT") + " " + right + ("null".equals(right) ? EMPTY : " ESCAPE '\\'") + ")";
                        }
                        return "(" + left + " " + (!"null".equals(right) ? "<>" : "IS NOT") + " " + right + ")";
                    }
                    case LT: {
                        return "(" + left + " < " + right + ")";
                    }
                    case LE: {
                        return "(" + left + " <= " + right + ")";
                    }
                    case GT: {
                        return "(" + left + " > " + right + ")";
                    }
                    case GE: {
                        return "(" + left + " >= " + right + ")";
                    }
                    case PROPERTY_ACCESS: {
                        throw new ODataNotImplementedException();
                    }
                }
                throw new ODataNotImplementedException();
            }
            case PROPERTY: {
                String returnStr = tableAlias + "." + ODataExpressionParser.getPropertyName(whereExpression);
                return returnStr;
            }
            case MEMBER: {
                Object memberExpStr = EMPTY;
                int i = 0;
                MemberExpression member = null;
                CommonExpression tempExp = whereExpression;
                while (tempExp != null && tempExp.getKind() == ExpressionKind.MEMBER) {
                    member = (MemberExpression)tempExp;
                    if (i > 0) {
                        memberExpStr = "." + (String)memberExpStr;
                    }
                    ++i;
                    memberExpStr = ODataExpressionParser.getPropertyName(member.getProperty()) + (String)memberExpStr;
                    tempExp = member.getPath();
                }
                memberExpStr = ODataExpressionParser.getPropertyName(tempExp) + "." + (String)memberExpStr;
                return tableAlias + "." + (String)memberExpStr;
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)whereExpression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                EdmLiteral uriLiteral = EdmSimpleTypeKind.parseUriLiteral((String)literal.getUriLiteral());
                Class<?> edmMap = edmMapping != null ? ((JPAEdmMappingImpl)edmMapping).getJPAType() : null;
                return ODataExpressionParser.evaluateComparingExpression(uriLiteral.getLiteral(), literalType, edmMap, positionalParameters, index);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)whereExpression;
                String first = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(0), tableAlias, ODataExpressionParser.getIndexValue(index, positionalParameters), positionalParameters, edmMapping);
                String second = methodExpression.getParameterCount() > 1 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(1), tableAlias, ODataExpressionParser.getIndexValue(index, positionalParameters), positionalParameters, edmMapping) : null;
                Object third = methodExpression.getParameterCount() > 2 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(2), tableAlias, ODataExpressionParser.getIndexValue(index, positionalParameters), positionalParameters, edmMapping) : null;
                switch (methodExpression.getMethod()) {
                    case SUBSTRING: {
                        third = third != null ? ", " + (String)third : EMPTY;
                        return String.format("SUBSTRING(%s, %s + 1 %s)", first, second, third);
                    }
                    case SUBSTRINGOF: {
                        if (methodFlag.get() != null && methodFlag.get() == 1) {
                            methodFlag.set(null);
                            return String.format("(CASE WHEN (%s LIKE CONCAT('%%',CONCAT(%s,'%%')) ESCAPE '\\') THEN TRUE ELSE FALSE END)", second, first);
                        }
                        return String.format("(CASE WHEN (%s LIKE CONCAT('%%',CONCAT(%s,'%%')) ESCAPE '\\') THEN TRUE ELSE FALSE END) = true", second, first);
                    }
                    case TOLOWER: {
                        return String.format("LOWER(%s)", first);
                    }
                    case TOUPPER: {
                        return String.format("UPPER(%s)", first);
                    }
                    case STARTSWITH: {
                        return String.format("%s LIKE CONCAT(%s,'%%') ESCAPE '\\'", first, second);
                    }
                    case ENDSWITH: {
                        return String.format("%s LIKE CONCAT('%%',%s) ESCAPE '\\'", first, second);
                    }
                }
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    private static EdmMapping getEdmMapping(BinaryExpression binaryExpression) throws EdmException {
        PropertyExpression left;
        if (binaryExpression != null && binaryExpression.getLeftOperand() instanceof PropertyExpression && (left = (PropertyExpression)binaryExpression.getLeftOperand()) != null && left.getEdmProperty() instanceof EdmElement) {
            EdmElement property = (EdmElement)left.getEdmProperty();
            return property.getMapping();
        }
        return null;
    }

    private static int getIndexValue(int index, Map<Integer, Object> map) {
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<Integer, Object> entry : map.entrySet()) {
                index = entry.getKey();
            }
            return index + 1;
        }
        return index;
    }

    public static Byte[] toByteArray(String uriLiteral) {
        int length = uriLiteral.length();
        if (length == 0) {
            return new Byte[0];
        }
        byte[] byteValues = uriLiteral.getBytes();
        Byte[] result = new Byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = new Byte(byteValues[i]);
        }
        return result;
    }

    private static String updateValueIfWildcards(String value) {
        if (value != null) {
            value = value.replace("\\", "\\\\");
            value = value.replace("%", "\\%");
            value = value.replace("_", "\\_");
        }
        return value;
    }

    public static String parseToJPASelectExpression(String tableAlias, ArrayList<String> selectedFields) {
        if (selectedFields == null || selectedFields.isEmpty()) {
            return tableAlias;
        }
        Object selectClause = EMPTY;
        Iterator<String> itr = selectedFields.iterator();
        int count = 0;
        while (itr.hasNext()) {
            selectClause = (String)selectClause + tableAlias + "." + itr.next();
            if (++count >= selectedFields.size()) continue;
            selectClause = (String)selectClause + ", ";
        }
        return selectClause;
    }

    public static String parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias) throws ODataJPARuntimeException {
        Object jpqlOrderByExpression = EMPTY;
        if (orderByExpression != null && orderByExpression.getOrders() != null) {
            List orderBys = orderByExpression.getOrders();
            Object orderByField = null;
            String orderByDirection = null;
            for (OrderExpression orderBy : orderBys) {
                try {
                    orderByField = orderBy.getExpression().getKind() == ExpressionKind.MEMBER ? ODataExpressionParser.parseToJPAWhereExpression(orderBy.getExpression(), tableAlias, 1, new ConcurrentHashMap<Integer, Object>(), null) : tableAlias + "." + ODataExpressionParser.getPropertyName(orderBy.getExpression());
                    orderByDirection = orderBy.getSortOrder() == SortOrder.asc ? EMPTY : " DESC";
                    jpqlOrderByExpression = (String)jpqlOrderByExpression + (String)orderByField + orderByDirection + " , ";
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        return ODataExpressionParser.normalizeOrderByExpression((String)jpqlOrderByExpression);
    }

    private static String normalizeOrderByExpression(String jpqlOrderByExpression) {
        if (jpqlOrderByExpression != EMPTY) {
            return jpqlOrderByExpression.substring(0, jpqlOrderByExpression.length() - 3);
        }
        return jpqlOrderByExpression;
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias) throws ODataJPARuntimeException {
        ConcurrentHashMap<Integer, Object> positionalParameters = new ConcurrentHashMap<Integer, Object>();
        String literal = null;
        String propertyName = null;
        EdmSimpleType edmSimpleType = null;
        Class<?> edmMappedType = null;
        StringBuilder keyFilters = new StringBuilder();
        int i = 0;
        for (KeyPredicate keyPredicate : keyPredicates) {
            int index;
            int n = index = null == ODataExpressionParser.getPositionalParametersThreadLocal() || ODataExpressionParser.getPositionalParametersThreadLocal().size() == 0 ? 1 : ODataExpressionParser.getIndexValue(1, ODataExpressionParser.getPositionalParametersThreadLocal());
            if (i > 0) {
                keyFilters.append(" AND ");
            }
            ++i;
            literal = keyPredicate.getLiteral();
            try {
                propertyName = keyPredicate.getProperty().getMapping().getInternalName();
                edmSimpleType = (EdmSimpleType)keyPredicate.getProperty().getType();
                edmMappedType = ((JPAEdmMappingImpl)keyPredicate.getProperty().getMapping()).getJPAType();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            literal = ODataExpressionParser.evaluateComparingExpression(literal, edmSimpleType, edmMappedType, positionalParameters, index);
            if (edmSimpleType == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance()) {
                keyFilters.append(tableAlias + "." + propertyName + " LIKE " + literal + " ESCAPE '\\'");
                continue;
            }
            keyFilters.append(tableAlias + "." + propertyName + " = " + literal);
        }
        if (keyFilters.length() > 0) {
            return keyFilters.toString();
        }
        return null;
    }

    public static Character[] toCharacterArray(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Character(array[i]);
        }
        return result;
    }

    public static String parseKeyPropertiesToJPAOrderByExpression(List<EdmProperty> edmPropertylist, String tableAlias) throws ODataJPARuntimeException {
        String propertyName = null;
        Object orderExpression = EMPTY;
        if (edmPropertylist == null) {
            return orderExpression;
        }
        for (EdmProperty edmProperty : edmPropertylist) {
            try {
                EdmMapping mapping = edmProperty.getMapping();
                propertyName = mapping != null && mapping.getInternalName() != null ? mapping.getInternalName() : edmProperty.getName();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            orderExpression = (String)orderExpression + tableAlias + "." + propertyName + " , ";
        }
        return ODataExpressionParser.normalizeOrderByExpression((String)orderExpression);
    }

    private static String evaluateComparingExpression(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType, Map<Integer, Object> positionalParameters, int index) throws ODataJPARuntimeException {
        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            uriLiteral = ODataExpressionParser.updateValueIfWildcards((String)uriLiteral);
            if (!positionalParameters.containsKey(index)) {
                if (edmMappedType != null) {
                    ODataExpressionParser.evaluateExpressionForString((String)uriLiteral, edmMappedType, positionalParameters, index);
                } else if (EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
                    positionalParameters.put(index, UUID.fromString(((String)uriLiteral).toString()));
                } else {
                    positionalParameters.put(index, String.valueOf(uriLiteral));
                }
            }
            uriLiteral = "?" + index;
        } else if (EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar datetime = (Calendar)edmSimpleType.valueOfString((String)uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                if (!positionalParameters.containsKey(index)) {
                    positionalParameters.put(index, datetime);
                }
                uriLiteral = "?" + index;
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar time = (Calendar)edmSimpleType.valueOfString((String)uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String hourValue = String.format("%02d", time.get(11));
                String minValue = String.format("%02d", time.get(12));
                String secValue = String.format("%02d", time.get(13));
                uriLiteral = hourValue + ":" + minValue + ":" + secValue;
                if (!positionalParameters.containsKey(index)) {
                    positionalParameters.put(index, Time.valueOf((String)uriLiteral));
                }
                uriLiteral = "?" + index;
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else {
            uriLiteral = ODataExpressionParser.evaluateExpressionForNumbers((String)uriLiteral, edmSimpleType, edmMappedType, positionalParameters, index);
        }
        ODataExpressionParser.removePositionalParametersThreadLocal();
        ODataExpressionParser.setPositionalParametersThreadLocal(positionalParameters);
        return uriLiteral;
    }

    private static String evaluateExpressionForNumbers(String uriLiteral, EdmSimpleType edmSimpleType, Class<?> edmMappedType, Map<Integer, Object> positionalParameters, int index) {
        Class type = edmMappedType == null ? edmSimpleType.getDefaultType() : edmMappedType;
        int size = positionalParameters.size();
        if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Long.valueOf((String)uriLiteral));
            }
        } else if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Double.valueOf((String)uriLiteral));
            }
        } else if (Integer.class.equals((Object)type) || Integer.TYPE.equals(type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Integer.valueOf((String)uriLiteral));
            }
        } else if (Byte.class.equals((Object)type) || Byte.TYPE.equals(type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Byte.valueOf((String)uriLiteral));
            }
        } else if (Byte[].class.equals((Object)type) || byte[].class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, ODataExpressionParser.toByteArray((String)uriLiteral));
            }
        } else if (Short.class.equals((Object)type) || Short.TYPE.equals(type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, Short.valueOf((String)uriLiteral));
            }
        } else if (BigDecimal.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigDecimal((String)uriLiteral));
            }
        } else if (BigInteger.class.equals((Object)type)) {
            if (!positionalParameters.containsKey(index)) {
                positionalParameters.put(index, new BigInteger((String)uriLiteral));
            }
        } else if ((Float.class.equals((Object)type) || Float.TYPE.equals(type)) && !positionalParameters.containsKey(index)) {
            positionalParameters.put(index, Float.valueOf((String)uriLiteral));
        }
        if (size + 1 == positionalParameters.size()) {
            uriLiteral = "?" + index;
        }
        return uriLiteral;
    }

    private static void evaluateExpressionForString(String uriLiteral, Class<?> edmMappedType, Map<Integer, Object> positionalParameters, int index) {
        if (edmMappedType.equals(char[].class)) {
            positionalParameters.put(index, uriLiteral.toCharArray());
        } else if (edmMappedType.equals(Character.TYPE)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else if (edmMappedType.equals(Character[].class)) {
            char[] charArray = uriLiteral.toCharArray();
            Character[] charObjectArray = ODataExpressionParser.toCharacterArray(charArray);
            positionalParameters.put(index, charObjectArray);
        } else if (edmMappedType.equals(Character.class)) {
            positionalParameters.put(index, Character.valueOf(uriLiteral.charAt(0)));
        } else if (edmMappedType.equals(UUID.class)) {
            positionalParameters.put(index, UUID.fromString(uriLiteral));
        } else if (edmMappedType.isEnum()) {
            Class<?> enCl = edmMappedType;
            positionalParameters.put(index, Enum.valueOf(enCl, uriLiteral));
        } else {
            positionalParameters.put(index, String.valueOf(uriLiteral));
        }
    }

    private static String getPropertyName(CommonExpression whereExpression) throws EdmException, ODataJPARuntimeException {
        EdmMapping mapping;
        EdmTyped edmProperty = ((PropertyExpression)whereExpression).getEdmProperty();
        if (edmProperty instanceof EdmNavigationProperty) {
            EdmNavigationProperty edmNavigationProperty = (EdmNavigationProperty)edmProperty;
            mapping = edmNavigationProperty.getMapping();
        } else if (edmProperty instanceof EdmProperty) {
            EdmProperty property = (EdmProperty)edmProperty;
            mapping = property.getMapping();
        } else {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        return mapping != null ? mapping.getInternalName() : edmProperty.getName();
    }

    public static void setPositionalParametersThreadLocal(Map<Integer, Object> parameter) {
        if (null != ODataExpressionParser.getPositionalParametersThreadLocal() && ODataExpressionParser.getPositionalParametersThreadLocal().size() > 0) {
            parameter.putAll(ODataExpressionParser.getPositionalParametersThreadLocal());
        }
        TreeMap<Integer, Object> map = new TreeMap<Integer, Object>(parameter);
        positionalParameters.set(map);
    }

    public static Map<Integer, Object> getPositionalParametersThreadLocal() {
        return positionalParameters.get();
    }

    public static void removePositionalParametersThreadLocal() {
        positionalParameters.remove();
    }
}

