/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.support;

import java.net.URI;
import java.util.ArrayList;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.util.UriBuilderFactory;

public final class RestTemplateAdapter
implements HttpExchangeAdapter {
    private final RestTemplate restTemplate;

    private RestTemplateAdapter(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return false;
    }

    @Override
    public void exchange(HttpRequestValues values) {
        this.restTemplate.exchange(this.newRequest(values), Void.class);
    }

    @Override
    public HttpHeaders exchangeForHeaders(HttpRequestValues values) {
        return this.restTemplate.exchange(this.newRequest(values), Void.class).getHeaders();
    }

    @Override
    public <T> T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.restTemplate.exchange(this.newRequest(values), bodyType).getBody();
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        return this.restTemplate.exchange(this.newRequest(values), Void.class);
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.restTemplate.exchange(this.newRequest(values), bodyType);
    }

    private RequestEntity<?> newRequest(HttpRequestValues values) {
        RequestEntity.BodyBuilder builder;
        HttpMethod httpMethod = values.getHttpMethod();
        Assert.notNull((Object)httpMethod, (String)"HttpMethod is required");
        if (values.getUri() != null) {
            builder = RequestEntity.method(httpMethod, values.getUri());
        } else if (values.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI expanded = uriBuilderFactory.expand(values.getUriTemplate(), values.getUriVariables());
                builder = RequestEntity.method(httpMethod, expanded);
            } else {
                builder = RequestEntity.method(httpMethod, values.getUriTemplate(), values.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        builder.headers(values.getHeaders());
        if (!values.getCookies().isEmpty()) {
            ArrayList cookies = new ArrayList();
            values.getCookies().forEach((name, cookieValues) -> cookieValues.forEach(value -> {
                HttpCookie cookie = new HttpCookie((String)name, (String)value);
                cookies.add(cookie.toString());
            }));
            builder.header("Cookie", String.join((CharSequence)"; ", cookies));
        }
        if (values.getBodyValue() != null) {
            return builder.body(values.getBodyValue());
        }
        return builder.build();
    }

    public static RestTemplateAdapter create(RestTemplate restTemplate) {
        return new RestTemplateAdapter(restTemplate);
    }
}

