/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.StatusLine;
import org.apache.olingo.client.api.communication.ODataServerErrorException;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.batch.BatchManager;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.communication.response.ODataBatchResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.header.ODataErrorResponseChecker;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ODataFlushException;
import org.apache.olingo.ext.proxy.api.ODataResponseError;
import org.apache.olingo.ext.proxy.commons.AbstractPersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PersistenceChanges;
import org.apache.olingo.ext.proxy.commons.ResponseStatusLine;
import org.apache.olingo.ext.proxy.commons.TransactionItems;

public class TransactionalPersistenceManagerImpl
extends AbstractPersistenceManager {
    private static final long serialVersionUID = -3320312269235907501L;
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.JSON;

    public TransactionalPersistenceManagerImpl(AbstractService<?> factory) {
        super(factory);
    }

    @Override
    protected void doFlush(PersistenceChanges changes, TransactionItems items) {
        ODataBatchRequest request = this.service.getClient().getBatchRequestFactory().getBatchRequest(this.service.getClient().getServiceRoot());
        request.setAccept(this.service.getClient().getConfiguration().getDefaultBatchAcceptFormat().toContentTypeString());
        BatchManager batchManager = (BatchManager)request.payloadManager();
        ArrayList<ODataBatchableRequest> requests = new ArrayList<ODataBatchableRequest>(changes.getChanges().size());
        ODataChangeset changeset = batchManager.addChangeset();
        for (Map.Entry<ODataBatchableRequest, EntityInvocationHandler> entry : changes.getChanges().entrySet()) {
            changeset.addRequest(entry.getKey());
            requests.add(entry.getKey());
        }
        ODataBatchResponse response = (ODataBatchResponse)batchManager.getResponse();
        if (response.getStatusCode() != 202 && response.getStatusCode() != 200) {
            throw new ODataServerErrorException((StatusLine)new ResponseStatusLine((ODataResponse)response), response.getRawResponse());
        }
        if (!items.isEmpty()) {
            ArrayList<ODataResponseError> errors = new ArrayList<ODataResponseError>();
            Iterator batchResItor = response.getBody();
            if (!batchResItor.hasNext()) {
                throw new IllegalStateException("Unexpected operation result");
            }
            ODataBatchResponseItem item = (ODataBatchResponseItem)batchResItor.next();
            if (!(item instanceof ODataChangesetResponseItem)) {
                throw new IllegalStateException("Unexpected batch response item " + item.getClass().getSimpleName());
            }
            ODataChangesetResponseItem chgres = (ODataChangesetResponseItem)item;
            int index = 0;
            for (Integer changesetItemId : items.sortedValues()) {
                EntityInvocationHandler handler;
                LOG.debug("Expected changeset item {}", (Object)changesetItemId);
                ODataResponse res = chgres.next();
                if (res.getStatusCode() >= 400) {
                    ContentType contentType = ContentType.fromAcceptHeader((String)request.getAccept());
                    errors.add(new ODataResponseError(ODataErrorResponseChecker.checkResponse(this.service.getClient(), (StatusLine)new ResponseStatusLine(res), (InputStream)res.getRawResponse(), (ContentType)contentType), index, (ODataRequest)requests.get(index)));
                    if (!this.service.getClient().getConfiguration().isContinueOnError()) {
                        throw new ODataFlushException(response.getStatusCode(), errors);
                    }
                }
                if ((handler = items.get(changesetItemId)) != null) {
                    if (res instanceof ODataEntityCreateResponse && (res.getStatusCode() == 201 || res.getStatusCode() == 204)) {
                        if (res.getStatusCode() == 201) {
                            handler.setEntity(((ODataEntityCreateResponse)res).getBody());
                            LOG.debug("Upgrade created object '{}'", (Object)handler);
                        } else {
                            handler.applyChanges();
                        }
                    } else if (res instanceof ODataEntityUpdateResponse && (res.getStatusCode() == 200 || res.getStatusCode() == 204)) {
                        if (res.getStatusCode() == 201) {
                            handler.setEntity(((ODataEntityUpdateResponse)res).getBody());
                            LOG.debug("Upgrade updated object '{}'", (Object)handler);
                        } else {
                            handler.applyChanges();
                        }
                    }
                }
                ++index;
            }
            if (!errors.isEmpty()) {
                throw new ODataFlushException(response.getStatusCode(), errors);
            }
        }
        response.close();
    }
}

