/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataPropertyRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.retrieve.AbstractODataRetrieveRequest;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataPropertyRequestImpl<T extends ClientProperty>
extends AbstractODataRetrieveRequest<T>
implements ODataPropertyRequest<T> {
    public ODataPropertyRequestImpl(ODataClient odataClient, URI query) {
        super(odataClient, query);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultFormat();
    }

    @Override
    public ODataRetrieveResponse<T> execute() {
        HttpResponse res = this.doExecute();
        return new ODataPropertyResponseImpl(this.odataClient, this.httpClient, res);
    }

    protected class ODataPropertyResponseImpl
    extends AbstractODataRetrieveRequest.AbstractODataRetrieveResponse {
        private T property;

        private ODataPropertyResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.property = null;
        }

        @Override
        public T getBody() {
            if (this.property == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ContentType.parse((String)this.getContentType())).toProperty(this.getRawResponse());
                    this.property = this.odataClient.getBinder().getODataProperty(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.property;
        }
    }
}

