/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.ant;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationImpl;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public abstract class AbstractTask
extends MatchingTask {
    private static final Localizer _loc = Localizer.forPackage(AbstractTask.class);
    protected final List<FileSet> fileSets = new ArrayList<FileSet>();
    protected boolean haltOnError = true;
    protected Path classpath = null;
    protected boolean useParent = false;
    protected boolean isolate = false;
    private ConfigurationImpl _conf = null;
    private AntClassLoader _cl = null;

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setIsolate(boolean isolate) {
        this.isolate = isolate;
    }

    public void setUseParentClassloader(boolean useParent) {
        this.useParent = useParent;
    }

    public Configuration getConfiguration() {
        if (this._conf == null) {
            this._conf = this.newConfiguration();
            this._conf.setDeferResourceLoading(true);
        }
        return this._conf;
    }

    protected abstract ConfigurationImpl newConfiguration();

    protected abstract void executeOn(String[] var1) throws Exception;

    protected ClassLoader getClassLoader() {
        if (this._cl != null) {
            return this._cl;
        }
        this._cl = this.classpath != null ? new AntClassLoader(this.getProject(), this.classpath, this.useParent) : new AntClassLoader(this.getProject().getCoreLoader(), this.getProject(), new Path(this.getProject()), this.useParent);
        this._cl.setIsolated(this.isolate);
        return this._cl;
    }

    protected void assertFiles(String[] files) {
        if (files.length == 0) {
            throw new BuildException(_loc.get("no-filesets").getMessage());
        }
    }

    public void setClasspath(Path classPath) {
        this.createClasspath().append(classPath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public Object createConfig() {
        return this.getConfiguration();
    }

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this._conf == null) {
            this._conf = this.newConfiguration();
        }
        ConfigurationProvider cp = null;
        String propertiesResource = this._conf.getPropertiesResource();
        if (propertiesResource == null) {
            cp = ProductDerivations.loadDefaults(this.getConfigPropertiesResourceLoader());
        } else if (this._conf.isDeferResourceLoading() && !StringUtils.isEmpty(propertiesResource)) {
            Map<String, String> result = Configurations.parseConfigResource(propertiesResource);
            String path = result.get("configResourcePath");
            String anchor = result.get("configResourceAnchor");
            cp = ProductDerivations.load(path, anchor, (ClassLoader)this.getConfigPropertiesResourceLoader());
        }
        if (cp != null) {
            cp.setInto(this._conf);
        }
        String[] files = this.getFiles();
        try {
            this.executeOn(files);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (this.haltOnError) {
                throw new BuildException(e);
            }
        }
        finally {
            this._conf.close();
            this._conf = null;
        }
    }

    private MultiClassLoader getConfigPropertiesResourceLoader() {
        MultiClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        loader.addClassLoader(this.getClassLoader());
        loader.addClassLoader(AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(this._conf.getClass())));
        return loader;
    }

    private String[] getFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (FileSet fs : this.fileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            for (int j = 0; j < dsFiles.length; ++j) {
                File f = new File(dsFiles[j]);
                if (!AccessController.doPrivileged(J2DoPrivHelper.isFileAction(f)).booleanValue()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(AccessController.doPrivileged(J2DoPrivHelper.getAbsolutePathAction(f)));
            }
        }
        return files.toArray(new String[files.size()]);
    }
}

