/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.visitor.BCVisitor;

public abstract class JumpInstruction
extends Instruction
implements InstructionPtr {
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);

    JumpInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public Instruction getTarget() {
        return this._target.getTargetInstruction();
    }

    public JumpInstruction setTarget(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
        return this;
    }

    @Override
    public boolean equalsInstruction(Instruction other) {
        if (this == other) {
            return true;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        Instruction target = ((JumpInstruction)other).getTarget();
        return target == null || this.getTarget() == null || target == this.getTarget();
    }

    @Override
    public void updateTargets() {
        this._target.updateTargets();
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        this._target.replaceTarget(oldTarget, newTarget);
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterJumpInstruction(this);
        visit.exitJumpInstruction(this);
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        this._target.setByteIndex(((JumpInstruction)orig)._target.getByteIndex());
    }

    @Override
    void read(DataInput in) throws IOException {
        super.read(in);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                this._target.setByteIndex(this.getByteIndex() + in.readInt());
                break;
            }
            default: {
                this._target.setByteIndex(this.getByteIndex() + in.readShort());
            }
        }
    }

    @Override
    void write(DataOutput out) throws IOException {
        super.write(out);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                out.writeInt(this._target.getByteIndex() - this.getByteIndex());
                break;
            }
            default: {
                out.writeShort(this._target.getByteIndex() - this.getByteIndex());
            }
        }
    }

    public void setOffset(int offset) {
        this._target.setByteIndex(this.getByteIndex() + offset);
    }

    public int getOffset() {
        return this._target.getByteIndex() - this.getByteIndex();
    }
}

