/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import org.apache.xbean.asm9.ClassWriter;

public class BCClassWriter
extends ClassWriter {
    private final ClassLoader _loader;

    public BCClassWriter(int flags, ClassLoader loader) {
        super(flags);
        this._loader = loader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> class2;
        Class<?> class1;
        try {
            class1 = this._loader.loadClass(type1.replace('/', '.'));
            class2 = this._loader.loadClass(type2.replace('/', '.'));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }
}

