/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.history;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.portals.applications.webcontent2.portlet.history.WebContentPage;

public class WebContentPageHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<WebContentPage> pageList = new LinkedList<WebContentPage>();
    private int curIndex = -1;

    public boolean isEmpty() {
        return this.pageList == null || this.pageList.isEmpty();
    }

    public boolean hasCurrentPage() {
        return this.curIndex >= 0;
    }

    public boolean hasPreviousPage() {
        return !this.isEmpty() && this.curIndex > 0;
    }

    public boolean hasNextPage() {
        return !this.isEmpty() && this.curIndex < this.pageList.size() - 1;
    }

    public WebContentPage getCurrentPage() {
        if (!this.hasCurrentPage()) {
            return null;
        }
        return this.pageList.get(this.curIndex);
    }

    public WebContentPage getPreviousPage() {
        if (!this.hasPreviousPage()) {
            return null;
        }
        --this.curIndex;
        return this.getCurrentPage();
    }

    public WebContentPage getNextPage() {
        if (!this.hasNextPage()) {
            return null;
        }
        ++this.curIndex;
        return this.getCurrentPage();
    }

    public void visitPage(WebContentPage page) {
        if (page == null) {
            throw new IllegalArgumentException("page must be not null.");
        }
        int index = this.pageList.indexOf(page);
        if (index != -1 && index == this.curIndex) {
            return;
        }
        while (this.hasNextPage()) {
            this.pageList.remove(this.curIndex + 1);
        }
        if (index != -1 && index < this.pageList.size()) {
            this.pageList.remove(index);
        }
        this.pageList.add(page);
        this.curIndex = this.pageList.size() - 1;
    }
}

