/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.proxy;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent2.portlet.proxy.PortletRequestContext;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.RequestContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyService;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class GenericReverseProxyPortlet
extends GenericVelocityPortlet {
    public static final String REMOTE_URI_PARAM_NAME = "remote.uri";
    private ReverseProxyService proxyService;

    public ReverseProxyService getProxyService() {
        return this.proxyService;
    }

    public void setProxyService(ReverseProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.invokeProxyService((PortletRequest)request, (PortletResponse)response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        this.invokeProxyService((PortletRequest)request, (PortletResponse)response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String param = StringUtils.trim((String)request.getParameter(REMOTE_URI_PARAM_NAME));
        if (StringUtils.isNotEmpty((String)param)) {
            response.setRenderParameter(REMOTE_URI_PARAM_NAME, param);
        }
    }

    protected void invokeProxyService(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        try {
            PortletRequestContext requestContext = new PortletRequestContext(request, response);
            ProxyContext proxyContext = new ProxyContext((RequestContext)requestContext);
            ProxyContext.setCurrentProxyContext((ProxyContext)proxyContext);
            this.getProxyService().invoke(proxyContext);
        }
        catch (ReverseProxyException e) {
            if (e.getStatusCode() > 0) {
                throw new PortletException("Response proxy processing exception status: " + e.getStatusCode(), (Throwable)e);
            }
            throw new PortletException((Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        finally {
            ProxyContext.removeCurrentProxyContext();
        }
    }
}

