/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent2.portlet.rewriter.ParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextLinesParserAdaptor
implements ParserAdaptor {
    private static Logger log = LoggerFactory.getLogger(AbstractTextLinesParserAdaptor.class);

    @Override
    public void rewrite(Rewriter rewriter, Reader reader, Writer writer) throws RewriterException {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        LineIterator lineIt = IOUtils.lineIterator((Reader)reader);
        while (lineIt.hasNext()) {
            String line = lineIt.nextLine();
            if (!StringUtils.isBlank((String)line)) {
                try {
                    line = this.rewriteLine(line);
                }
                catch (Exception e) {
                    log.warn("Error during {}: {}", (Object)"replacement", (Object)e);
                }
            }
            out.println(line);
        }
        out.flush();
    }

    protected abstract String rewriteLine(String var1) throws Exception;

    @Override
    public void parse(Rewriter rewriter, Reader reader) throws RewriterException {
        throw new UnsupportedOperationException("Text lines parser adaptor does not support parse() method.");
    }
}

