/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.portals.applications.webcontent2.portlet.rewriter.BasicRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.ParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RulesetRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RulesetRewriterImpl;
import org.apache.portals.applications.webcontent2.portlet.rewriter.html.SwingParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Ruleset;
import org.apache.portals.applications.webcontent2.portlet.rewriter.xml.SaxParserAdaptor;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MappingRewriterController
implements RewriterController {
    protected static final Logger log = LoggerFactory.getLogger(MappingRewriterController.class);
    static final String CONFIG_MAPPING_FILE = "mapping";
    static final String CONFIG_BASIC_REWRITER = "basic.class";
    static final String CONFIG_RULESET_REWRITER = "ruleset.class";
    static final String CONFIG_ADAPTOR_HTML = "adaptor.html";
    static final String CONFIG_ADAPTOR_XML = "adaptor.xml";
    protected String mappingFile = null;
    protected Mapping mapper = null;
    protected Map rulesets = Collections.synchronizedMap(new HashMap());
    protected Class basicRewriterClass = BasicRewriter.class;
    protected Class rulesetRewriterClass = RulesetRewriterImpl.class;
    protected Map<String, Class> parserAdaptorMimeTypeClassMap;
    protected Map<String, String[]> basicRewriterProps;
    protected Map<String, String[]> rulesetRewriterProps;
    protected Map<String, Map<String, String[]>> parserAdaptorMimeTypePropsMap;

    public MappingRewriterController(String mappingFile) throws RewriterException {
        this.mappingFile = mappingFile;
        this.parserAdaptorMimeTypeClassMap = new HashMap<String, Class>();
        this.parserAdaptorMimeTypeClassMap.put("text/html", SwingParserAdaptor.class);
        this.parserAdaptorMimeTypeClassMap.put("text/xml", SaxParserAdaptor.class);
        if (this.mappingFile != null) {
            this.loadMapping();
        }
    }

    public MappingRewriterController(String mappingFile, Class basicRewriterClass, Class ruleBasedRewriterClass, Map<String, Class> adaptorMimeTypeClassMap) throws RewriterException {
        this.mappingFile = mappingFile;
        this.parserAdaptorMimeTypeClassMap = new HashMap<String, Class>();
        this.parserAdaptorMimeTypeClassMap.put("text/html", SwingParserAdaptor.class);
        this.parserAdaptorMimeTypeClassMap.put("text/xml", SaxParserAdaptor.class);
        if (basicRewriterClass != null) {
            this.basicRewriterClass = basicRewriterClass;
        }
        if (ruleBasedRewriterClass != null) {
            this.rulesetRewriterClass = ruleBasedRewriterClass;
        }
        if (adaptorMimeTypeClassMap != null) {
            this.parserAdaptorMimeTypeClassMap.putAll(adaptorMimeTypeClassMap);
        }
        if (this.mappingFile != null) {
            this.loadMapping();
        }
    }

    public MappingRewriterController(String mappingFile, List rewriterClasses, List adaptorClasses) throws RewriterException {
        this.mappingFile = mappingFile;
        this.parserAdaptorMimeTypeClassMap = new HashMap<String, Class>();
        this.parserAdaptorMimeTypeClassMap.put("text/html", SwingParserAdaptor.class);
        this.parserAdaptorMimeTypeClassMap.put("text/xml", SaxParserAdaptor.class);
        if (rewriterClasses.size() > 0) {
            this.basicRewriterClass = (Class)rewriterClasses.get(0);
            if (rewriterClasses.size() > 1) {
                this.rulesetRewriterClass = (Class)rewriterClasses.get(1);
            }
        }
        if (adaptorClasses.size() > 0) {
            this.parserAdaptorMimeTypeClassMap.put("text/html", (Class)adaptorClasses.get(0));
            if (adaptorClasses.size() > 1) {
                this.parserAdaptorMimeTypeClassMap.put("text/xmll", (Class)adaptorClasses.get(1));
            }
        }
        if (this.mappingFile != null) {
            this.loadMapping();
        }
    }

    public MappingRewriterController(String mappingFile, String basicRewriterClassName, String rulesetRewriterClassName, String adaptorHtmlClassName, String adaptorXmlClassName) throws RewriterException {
        this(mappingFile, MappingRewriterController.toClassList(basicRewriterClassName, rulesetRewriterClassName), MappingRewriterController.toClassList(adaptorHtmlClassName, adaptorXmlClassName));
    }

    protected static List toClassList(String classNameA, String classNameB) {
        try {
            ArrayList list = new ArrayList(2);
            if (classNameA != null) {
                list.add(Class.forName(classNameA));
            }
            if (classNameB != null) {
                list.add(Class.forName(classNameB));
            }
            return list;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Rewriter createRewriter() throws InstantiationException, IllegalAccessException {
        Rewriter rewriter = (Rewriter)this.basicRewriterClass.newInstance();
        if (this.basicRewriterProps != null) {
            try {
                for (Map.Entry<String, String[]> entry : this.basicRewriterProps.entrySet()) {
                    BeanUtils.setProperty((Object)rewriter, (String)entry.getKey(), (Object)entry.getValue());
                }
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return rewriter;
    }

    @Override
    public RulesetRewriter createRewriter(Ruleset ruleset) throws RewriterException {
        try {
            RulesetRewriter rewriter = (RulesetRewriter)this.rulesetRewriterClass.newInstance();
            rewriter.setRuleset(ruleset);
            if (this.rulesetRewriterProps != null) {
                for (Map.Entry<String, String[]> entry : this.rulesetRewriterProps.entrySet()) {
                    BeanUtils.setProperty((Object)rewriter, (String)entry.getKey(), (Object)entry.getValue());
                }
            }
            return rewriter;
        }
        catch (Exception e) {
            log.error("Error creating rewriter class", (Throwable)e);
            return null;
        }
    }

    @Override
    public ParserAdaptor createParserAdaptor(String mimeType) throws RewriterException {
        try {
            ParserAdaptor parserAdaptor = null;
            Class parserAdaptorClass = this.parserAdaptorMimeTypeClassMap.get(mimeType);
            if (parserAdaptorClass != null) {
                Map<String, String[]> parserAdaptorProps;
                parserAdaptor = (ParserAdaptor)parserAdaptorClass.newInstance();
                if (this.parserAdaptorMimeTypePropsMap != null && (parserAdaptorProps = this.parserAdaptorMimeTypePropsMap.get(mimeType)) != null) {
                    for (Map.Entry<String, String[]> entry : parserAdaptorProps.entrySet()) {
                        BeanUtils.setProperty((Object)parserAdaptor, (String)entry.getKey(), (Object)entry.getValue());
                    }
                }
            }
            return parserAdaptor;
        }
        catch (Exception e) {
            log.error("Error creating rewriter class", (Throwable)e);
            return null;
        }
    }

    protected void loadMapping() throws RewriterException {
        if (this.mappingFile == null) {
            throw new RewriterException("The mapping file is not set.");
        }
        Reader reader = this.getReader(this.mappingFile);
        try {
            if (reader == null && this.mappingFile != null) {
                File file = new File(this.mappingFile);
                if (!file.isFile()) {
                    throw new RewriterException("The mapping file is not available: " + this.mappingFile);
                }
                this.mapper = new Mapping();
                this.mapper.loadMapping(file.toURL());
            } else {
                InputSource is = new InputSource(reader);
                is.setSystemId(this.mappingFile);
                this.mapper.loadMapping(is);
            }
        }
        catch (Exception e) {
            String msg = "RewriterService: Error in castor mapping creation";
            log.error(msg, (Throwable)e);
            throw new RewriterException(msg, e);
        }
    }

    @Override
    public Ruleset lookupRuleset(String id) {
        return (Ruleset)this.rulesets.get(id);
    }

    @Override
    public Ruleset loadRuleset(Reader reader) {
        Ruleset ruleset = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            Document doc = builder.parse(source);
            Unmarshaller unmarshaller = new Unmarshaller(this.mapper);
            ruleset = (Ruleset)unmarshaller.unmarshal((Node)doc);
            ruleset.sync();
            this.rulesets.put(ruleset.getId(), ruleset);
        }
        catch (Throwable t) {
            log.error("ForwardService: Could not unmarshal: " + reader, t);
        }
        return ruleset;
    }

    @Override
    public Ruleset loadRuleset(InputStream input) {
        Ruleset ruleset = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            InputSource source = new InputSource(input);
            Document doc = builder.parse(source);
            Unmarshaller unmarshaller = new Unmarshaller(this.mapper);
            ruleset = (Ruleset)unmarshaller.unmarshal((Node)doc);
            ruleset.sync();
            this.rulesets.put(ruleset.getId(), ruleset);
        }
        catch (Throwable t) {
            log.error("ForwardService: Could not unmarshal: " + input, t);
        }
        return ruleset;
    }

    public Map<String, String[]> getBasicRewriterProps() {
        return this.basicRewriterProps;
    }

    public void setBasicRewriterProps(Map<String, String[]> props) {
        this.basicRewriterProps = props;
    }

    public Map<String, String[]> getRulesetRewriterProps() {
        return this.rulesetRewriterProps;
    }

    public void setRulesetRewriterProps(Map<String, String[]> props) {
        this.rulesetRewriterProps = props;
    }

    public Map<String, Map<String, String[]>> getParserAdaptorMimeTypePropsMap() {
        return this.parserAdaptorMimeTypePropsMap;
    }

    public void setParserAdaptorMimeTypePropsMap(Map<String, Map<String, String[]>> propsMap) {
        this.parserAdaptorMimeTypePropsMap = propsMap;
    }

    protected Reader getReader(String resourcePath) throws RewriterException {
        return null;
    }
}

