/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.io.IOException;
import java.util.List;
import org.apache.commons.chain.Context;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyException;
import org.apache.portals.applications.webcontent2.proxy.ReverseProxyService;
import org.apache.portals.applications.webcontent2.proxy.impl.ProxyProcessingChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReverseProxyService
implements ReverseProxyService {
    private static Logger log = LoggerFactory.getLogger(DefaultReverseProxyService.class);
    private final ProxyProcessingChain proxyProcessingChain;

    public DefaultReverseProxyService(ProxyProcessingChain proxyProcessingChain) {
        this.proxyProcessingChain = proxyProcessingChain;
    }

    @Override
    public void invoke(ProxyContext proxyContext) throws ReverseProxyException, IOException {
        this.proxyProcessingChain.execute((Context)proxyContext);
        if (proxyContext.hasException()) {
            this.logExceptions(proxyContext.getExceptions());
            Exception e = proxyContext.getExceptions().get(0);
            if (e instanceof ReverseProxyException) {
                throw (ReverseProxyException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new ReverseProxyException(e);
        }
    }

    protected void logExceptions(List<Exception> exceptions) {
        if (log.isDebugEnabled()) {
            for (Exception ex : exceptions) {
                log.error("Reverse proxy service error.", (Throwable)ex);
            }
        } else {
            for (Exception ex : exceptions) {
                log.error("Reverse proxy service error. " + ex);
            }
        }
    }
}

