/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.proxy.impl;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.portals.applications.webcontent2.proxy.impl.AbstractProxyMapping;

public class SimpleProxyMapping
extends AbstractProxyMapping {
    private String localBasePath;
    private URI remoteBaseURI;

    public String getLocal() {
        return this.localBasePath;
    }

    public void setLocal(String localBasePath) {
        this.localBasePath = localBasePath;
    }

    public URI getRemote() {
        return this.remoteBaseURI;
    }

    public void setRemote(URI remoteBaseURI) {
        this.remoteBaseURI = remoteBaseURI;
    }

    @Override
    public boolean matchesLocal(String localPath) {
        return StringUtils.startsWith((String)localPath, (String)this.localBasePath);
    }

    @Override
    public String resolveRemoteFromLocal(String localPath) {
        if (this.matchesLocal(localPath)) {
            return this.remoteBaseURI + localPath.substring(this.localBasePath.length());
        }
        return null;
    }

    @Override
    public boolean matchesRemote(URI remoteURI) {
        String remoteURIString = remoteURI.toString();
        if (this.remoteBaseURI.getScheme() == null && remoteURI.getScheme() != null) {
            remoteURIString = remoteURIString.substring(remoteURI.getScheme().length() + 1);
        }
        return StringUtils.startsWith((String)remoteURIString, (String)this.remoteBaseURI.toString());
    }

    @Override
    public String resolveLocalFromRemote(URI remoteURI) {
        if (this.matchesRemote(remoteURI)) {
            return this.localBasePath + StringUtils.substringAfter((String)remoteURI.toString(), (String)this.remoteBaseURI.toString());
        }
        return null;
    }
}

