/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.persistence.sqlmapdao;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.dao.client.DaoManager;
import com.ibatis.jpetstore.domain.Item;
import com.ibatis.jpetstore.domain.LineItem;
import com.ibatis.jpetstore.domain.Order;
import com.ibatis.jpetstore.persistence.iface.ItemDao;
import com.ibatis.jpetstore.persistence.sqlmapdao.BaseSqlMapDao;
import java.util.HashMap;

public class ItemSqlMapDao
extends BaseSqlMapDao
implements ItemDao {
    public ItemSqlMapDao(DaoManager daoManager) {
        super(daoManager);
    }

    public void updateQuantity(Order order) {
        for (int i = 0; i < order.getLineItems().size(); ++i) {
            LineItem lineItem = (LineItem)order.getLineItems().get(i);
            String itemId = lineItem.getItemId();
            Integer increment = new Integer(lineItem.getQuantity());
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("itemId", itemId);
            param.put("increment", increment);
            this.update("updateInventoryQuantity", param);
        }
    }

    public boolean isItemInStock(String itemId) {
        Integer i = (Integer)this.queryForObject("getInventoryQuantity", (Object)itemId);
        return i != null && i > 0;
    }

    public PaginatedList getItemListByProduct(String productId) {
        return this.queryForPaginatedList("getItemListByProduct", (Object)productId, 4);
    }

    public Item getItem(String itemId) {
        Integer i = (Integer)this.queryForObject("getInventoryQuantity", (Object)itemId);
        Item item = (Item)this.queryForObject("getItem", (Object)itemId);
        item.setQuantity(i.intValue());
        return item;
    }
}

