/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.presentation;

import com.ibatis.jpetstore.domain.Cart;
import com.ibatis.jpetstore.domain.CartItem;
import com.ibatis.jpetstore.domain.Item;
import com.ibatis.jpetstore.service.CatalogService;
import com.ibatis.struts.ActionContext;
import com.ibatis.struts.BaseBean;
import java.util.Iterator;
import java.util.Map;

public class CartBean
extends BaseBean {
    private static final CatalogService catalogService = CatalogService.getInstance();
    private Cart cart = new Cart();
    private String workingItemId;
    private String pageDirection;

    public Cart getCart() {
        return this.cart;
    }

    public void setCart(Cart cart) {
        this.cart = cart;
    }

    public String getWorkingItemId() {
        return this.workingItemId;
    }

    public void setWorkingItemId(String workingItemId) {
        this.workingItemId = workingItemId;
    }

    public String getPageDirection() {
        return this.pageDirection;
    }

    public void setPageDirection(String pageDirection) {
        this.pageDirection = pageDirection;
    }

    public String addItemToCart() {
        if (this.cart.containsItemId(this.workingItemId)) {
            this.cart.incrementQuantityByItemId(this.workingItemId);
        } else {
            boolean isInStock = catalogService.isItemInStock(this.workingItemId);
            Item item = catalogService.getItem(this.workingItemId);
            this.cart.addItem(item, isInStock);
        }
        return "success";
    }

    public String removeItemFromCart() {
        Item item = this.cart.removeItemById(this.workingItemId);
        if (item == null) {
            ActionContext.getActionContext().setSimpleMessage("Attempted to remove null CartItem from Cart.");
            return "failure";
        }
        return "success";
    }

    public String updateCartQuantities() {
        Map parameterMap = ActionContext.getActionContext().getParameterMap();
        Iterator cartItems = this.getCart().getAllCartItems();
        while (cartItems.hasNext()) {
            CartItem cartItem = (CartItem)cartItems.next();
            String itemId = cartItem.getItem().getItemId();
            try {
                int quantity = Integer.parseInt((String)parameterMap.get(itemId));
                this.getCart().setQuantityByItemId(itemId, quantity);
                if (quantity >= 1) continue;
                cartItems.remove();
            }
            catch (Exception e) {}
        }
        return "success";
    }

    public String switchCartPage() {
        if ("next".equals(this.pageDirection)) {
            this.cart.getCartItemList().nextPage();
        } else if ("previous".equals(this.pageDirection)) {
            this.cart.getCartItemList().previousPage();
        }
        return "success";
    }

    public String viewCart() {
        return "success";
    }

    public void clear() {
        this.cart = new Cart();
        this.workingItemId = null;
        this.pageDirection = null;
    }
}

