/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.springmvc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedSet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.applications.springmvc.DOMTree;
import org.apache.portals.applications.springmvc.DOMTreeService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.mvc.AbstractController;

public class DOMTreeViewController
extends AbstractController
implements InitializingBean,
PortletConfigAware {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$applications$springmvc$DOMTreeViewController == null ? (class$org$apache$portals$applications$springmvc$DOMTreeViewController = DOMTreeViewController.class$((String)"org.apache.portals.applications.springmvc.DOMTreeViewController")) : class$org$apache$portals$applications$springmvc$DOMTreeViewController));
    private DOMTreeService domTreeService;
    private PortletConfig portletConfig;
    private String xmlFilePath = null;
    private String xmlFileName = null;
    static /* synthetic */ Class class$org$apache$portals$applications$springmvc$DOMTreeViewController;

    public void afterPropertiesSet() throws Exception {
        if (this.domTreeService == null) {
            throw new IllegalArgumentException("A DOMTreeService is required");
        }
    }

    public ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        ArrayList<DOMTree> addTo = new ArrayList<DOMTree>();
        if (this.getXmlFilePath() != null) {
            addTo.add(new DOMTree(this.getXmlFileName(), this.getXmlFilePath()));
        }
        SortedSet domTreeSet = this.domTreeService.parseAllDOMTrees((PortletRequest)request, this.getPortletContext(), addTo);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("messages", this.portletConfig.getResourceBundle(request.getLocale()));
        model.put("domTreeList", domTreeSet);
        model.put("domNodeHelper", new DOMTreeService.DOMNodeHelper());
        return new ModelAndView("domTreeView", "model", model);
    }

    public void setDomTreeService(DOMTreeService domTreeService) {
        this.domTreeService = domTreeService;
    }

    public String getXmlFilePath() {
        return this.xmlFilePath;
    }

    public void setXmlFilePath(String xmlFile) {
        this.xmlFilePath = xmlFile;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public void setXmlFileName(String xmlFileName) {
        this.xmlFileName = xmlFileName;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

