/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.jsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.apache.portals.bridges.jsf.PortletUIViewRoot;

public class FacesPortlet
extends GenericServletPortlet {
    private static final Log log = LogFactory.getLog((Class)FacesPortlet.class);
    public static final String VIEW_ROOT = "org.apache.portals.bridges.jsf.VIEW_ROOT";
    public static final String REQUEST_SERVLET_PATH = "org.apache.portals.bridges.jsf.REQUEST_SERVLET_PATH";
    public static final String REQUEST_TYPE = "org.apache.portals.bridges.jsf.request_type";
    public static final String JSF_VIEW_ID = "jsf_viewid";
    public static final String JSF_EDIT_ID = "jsf_editid";
    public static final String JSF_HELP_ID = "jsf_helpid";
    public static final String JSF_CUSTOM_ID = "jsf_customid";
    public static final String PARAM_ACTION_PAGE = "ActionPage";
    public static final String PARAM_CUSTOM_PAGE = "CustomPage";
    public static final String PARAM_EDIT_PAGE = "EditPage";
    public static final String PARAM_HELP_PAGE = "HelpPage";
    public static final String PARAM_VIEW_PAGE = "ViewPage";
    public static final String ACTION_REQUEST = "ACTION";
    public static final String VIEW_REQUEST = "VIEW";
    public static final String CUSTOM_REQUEST = "CUSTOM";
    public static final String EDIT_REQUEST = "EDIT";
    public static final String HELP_REQUEST = "HELP";
    public static final String FACES_MESSAGES = "FACES_MESSAGES";
    public static final String PARAM_UNIQUE_IDS = "OverrideUniqueIds";
    private String defaultActionPage = null;
    private String defaultCustomPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;
    private String defaultViewPage = null;
    private String uniqueIds = null;
    private static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private Application application = null;
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private PortletConfig portletConfig = null;

    public void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Begin FacesPortlet.destory() ");
        }
        this.application = null;
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.portletConfig = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)"End FacesPortlet.destory() ");
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Begin FacesPortlet.init() ");
        }
        super.init(portletConfig);
        this.portletConfig = portletConfig;
        this.defaultViewPage = portletConfig.getInitParameter(PARAM_VIEW_PAGE);
        this.defaultEditPage = portletConfig.getInitParameter(PARAM_EDIT_PAGE);
        this.defaultHelpPage = portletConfig.getInitParameter(PARAM_HELP_PAGE);
        this.uniqueIds = portletConfig.getInitParameter(PARAM_UNIQUE_IDS);
        if (null == this.defaultViewPage) {
            throw new PortletException("Portlet " + portletConfig.getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (null == this.defaultActionPage) {
            this.defaultActionPage = this.defaultViewPage;
        }
        if (null == this.defaultCustomPage) {
            this.defaultCustomPage = this.defaultViewPage;
        }
        if (null == this.defaultHelpPage) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        if (null == this.defaultEditPage) {
            this.defaultEditPage = this.defaultViewPage;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"End FacesPortlet.init() ");
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.process((PortletRequest)request, (PortletResponse)response, this.defaultEditPage, EDIT_REQUEST, JSF_EDIT_ID);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.defaultHelpPage != null && this.defaultHelpPage.endsWith(".html")) {
            super.doHelp(request, response);
        } else {
            this.process((PortletRequest)request, (PortletResponse)response, this.defaultHelpPage, HELP_REQUEST, JSF_HELP_ID);
        }
    }

    public void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.process((PortletRequest)request, (PortletResponse)response, this.defaultCustomPage, CUSTOM_REQUEST, JSF_CUSTOM_ID);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.process((PortletRequest)request, (PortletResponse)response, this.defaultViewPage, VIEW_REQUEST, JSF_VIEW_ID);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String viewId = JSF_CUSTOM_ID;
        if (request.getPortletMode().equals((Object)PortletMode.VIEW)) {
            viewId = JSF_VIEW_ID;
        } else if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            viewId = JSF_EDIT_ID;
        } else if (request.getPortletMode().equals((Object)PortletMode.HELP)) {
            viewId = JSF_HELP_ID;
        }
        this.process((PortletRequest)request, (PortletResponse)response, this.defaultActionPage, ACTION_REQUEST, viewId);
    }

    public FacesContextFactory getFacesContextFactory() throws PortletException {
        if (this.facesContextFactory != null) {
            return this.facesContextFactory;
        }
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrieved facesContextFactory " + this.facesContextFactory));
            }
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new PortletException(e.getMessage(), rootCause);
        }
        return this.facesContextFactory;
    }

    public Lifecycle getLifecycle() throws PortletException {
        if (this.lifecycle != null) {
            return this.lifecycle;
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrieved lifecycleFactory " + lifecycleFactory));
            }
            String lifecycleId = this.portletConfig.getPortletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            if (log.isDebugEnabled()) {
                log.debug((Object)("lifecycleId " + lifecycleId));
            }
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrieved lifecycle from lifecycleFactory " + this.lifecycle));
            }
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new PortletException(e.getMessage(), rootCause);
        }
        return this.lifecycle;
    }

    private void process(PortletRequest request, PortletResponse response, String defaultPage, String requestType, String viewId) throws PortletException, IOException {
        boolean actionRequest = ACTION_REQUEST.equals(requestType);
        boolean renderRequest = !actionRequest;
        String defaultView = defaultPage;
        request.setAttribute(REQUEST_TYPE, (Object)requestType);
        if (actionRequest) {
            log.trace((Object)"Begin FacesPortlet.processAction()");
        }
        this.cleanUpAfterPortal(request, response);
        FacesContext context = this.getFacesContextFactory().getFacesContext((Object)this.portletConfig.getPortletContext(), (Object)request, (Object)response, this.getLifecycle());
        this.setDefaultView(context, defaultPage, viewId);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Begin Executing phases");
        }
        this.preProcessFaces(context);
        try {
            if (actionRequest) {
                String vi = context.getViewRoot().getViewId();
                context.getApplication().getViewHandler().restoreView(context, vi);
                this.getLifecycle().execute(context);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"End Executing phases");
                }
                request.getPortletSession().setAttribute(this.createViewRootKey(context, defaultPage, viewId), (Object)context.getViewRoot());
                ActionResponse actionResponse = (ActionResponse)response;
                this.saveFacesMessages(context, request.getPortletSession());
            } else if (renderRequest) {
                String vi = context.getViewRoot().getViewId();
                context.getApplication().getViewHandler().restoreView(context, vi);
                this.restoreFacesMessages(context, request.getPortletSession());
                this.getLifecycle().render(context);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"End executing RenderResponse phase ");
                }
            } else {
                throw new PortletException("Request must be of type ActionRequest or RenderRequest");
            }
            request.getPortletSession().setAttribute(viewId, (Object)context.getViewRoot().getViewId(), 2);
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new PortletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof PortletException) {
                throw (PortletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new PortletException(t.getMessage(), t);
        }
        finally {
            context.release();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"End FacesPortlet.process()");
        }
    }

    protected void preProcessFaces(FacesContext context) {
    }

    private String createViewRootKey(FacesContext context, String defaultView, String viewId) {
        PortletRequest portletRequest = (PortletRequest)context.getExternalContext().getRequest();
        String view = (String)portletRequest.getPortletSession().getAttribute(viewId, 2);
        if (view == null) {
            view = defaultView;
        }
        String key = "org.apache.portals.bridges.jsf.VIEW_ROOT:" + this.getPortletName();
        UIViewRoot root = context.getViewRoot();
        key = root != null ? key + ":" + root.getViewId() : key + ":" + view;
        if (this.uniqueIds != null) {
            PortletResponse response = (PortletResponse)context.getExternalContext().getResponse();
            if (!(response instanceof RenderResponse)) {
                log.error((Object)"Cant encode action response");
            } else {
                RenderResponse rr = (RenderResponse)response;
                key = key + rr.getNamespace();
            }
        }
        return key;
    }

    private void setDefaultView(FacesContext facesContext, String defaultView, String viewId) {
        PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
        if (portletRequest instanceof ActionRequest) {
            String view = (String)portletRequest.getPortletSession().getAttribute(viewId, 2);
            if (null != facesContext.getViewRoot() && null != facesContext.getViewRoot().getViewId()) {
                defaultView = facesContext.getViewRoot().getViewId();
            } else if (null != view) {
                defaultView = view;
            }
            UIViewRoot viewRoot = (UIViewRoot)portletRequest.getPortletSession().getAttribute(this.createViewRootKey(facesContext, defaultView, viewId));
            if (viewRoot != null) {
                facesContext.setViewRoot(viewRoot);
                defaultView = facesContext.getViewRoot().getViewId();
            } else {
                facesContext.setViewRoot((UIViewRoot)new PortletUIViewRoot());
                facesContext.getViewRoot().setViewId(view);
                String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
                facesContext.getViewRoot().setRenderKitId(defaultRenderKitId != null ? defaultRenderKitId : "HTML_BASIC");
                portletRequest.getPortletSession().setAttribute(this.createViewRootKey(facesContext, view, viewId), (Object)facesContext.getViewRoot());
            }
            portletRequest.setAttribute(REQUEST_SERVLET_PATH, (Object)defaultView.replaceAll("[.]jsp", ".jsf"));
        } else if (portletRequest instanceof RenderRequest) {
            String view = (String)portletRequest.getPortletSession().getAttribute(viewId, 2);
            if (null == facesContext.getViewRoot()) {
                UIViewRoot viewRoot;
                if (view == null) {
                    view = defaultView;
                }
                if (null != (viewRoot = (UIViewRoot)portletRequest.getPortletSession().getAttribute(this.createViewRootKey(facesContext, view, viewId)))) {
                    facesContext.setViewRoot(viewRoot);
                    defaultView = facesContext.getViewRoot().getViewId();
                } else {
                    facesContext.setViewRoot((UIViewRoot)new PortletUIViewRoot());
                    facesContext.getViewRoot().setViewId(view);
                    String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
                    facesContext.getViewRoot().setRenderKitId(defaultRenderKitId != null ? defaultRenderKitId : "HTML_BASIC");
                    portletRequest.getPortletSession().setAttribute(this.createViewRootKey(facesContext, view, viewId), (Object)facesContext.getViewRoot());
                }
            }
            portletRequest.setAttribute(REQUEST_SERVLET_PATH, (Object)view.replaceAll(".jsp", ".jsf"));
        }
    }

    private void saveFacesMessages(FacesContext context, PortletSession session) {
        Iterator msgs = context.getMessages();
        if (msgs != null && msgs.hasNext()) {
            HashMap facesMsgs = new HashMap();
            Iterator idsWithMsgs = context.getClientIdsWithMessages();
            while (idsWithMsgs.hasNext()) {
                String clientId = (String)idsWithMsgs.next();
                ArrayList clientMsgList = (ArrayList)facesMsgs.get(clientId);
                if (clientMsgList == null) {
                    clientMsgList = new ArrayList();
                    facesMsgs.put(clientId, clientMsgList);
                }
                Iterator clientMsgs = context.getMessages(clientId);
                while (clientMsgs != null && clientMsgs.hasNext()) {
                    clientMsgList.add(clientMsgs.next());
                }
            }
            Iterator msgsWithoutId = context.getMessages(null);
            if (msgsWithoutId != null && msgsWithoutId.hasNext()) {
                ArrayList msgWithoutIdList = new ArrayList();
                while (msgsWithoutId.hasNext()) {
                    msgWithoutIdList.add(msgsWithoutId.next());
                }
                facesMsgs.put("null", msgWithoutIdList);
            }
            session.setAttribute(FACES_MESSAGES, facesMsgs);
        }
    }

    private void restoreFacesMessages(FacesContext context, PortletSession session) {
        Map facesMsgs = (Map)session.getAttribute(FACES_MESSAGES);
        if (facesMsgs != null) {
            Iterator clientIds = facesMsgs.keySet().iterator();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                List clientMsgList = (List)facesMsgs.get(clientId);
                if (clientId.equals("null")) {
                    clientId = null;
                }
                for (int index = 0; index < clientMsgList.size(); ++index) {
                    FacesMessage msg = (FacesMessage)clientMsgList.get(index);
                    context.addMessage(clientId, msg);
                }
                clientMsgList.clear();
            }
            facesMsgs.clear();
            session.setAttribute(FACES_MESSAGES, null);
        }
    }

    protected void cleanUpAfterPortal(PortletRequest request, PortletResponse response) {
        if (request != null) {
            request.removeAttribute("javax.faces.webapp.COMPONENT_TAG_STACK");
            request.removeAttribute("javax.faces.webapp.CURRENT_VIEW_ROOT");
            request.removeAttribute("javax.faces.webapp.CURRENT_FACES_CONTEXT");
        }
    }
}

