/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;

/**
 * TestHelloJRubyScriptPortlet
 * 
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id: TestHelloJRubyScriptPortlet.java 936987 2010-04-22 18:01:59Z woonsan $
 */
public class TestHelloJRubyScriptPortlet extends AbstractSimpleScriptPortletTestCase
{
    @Override
    protected Map<String, String> getPortletInitParameters()
    {
        Map<String, String> initParams = new HashMap<String, String>();
        initParams.put(ScriptPortlet.ENGINE, "jruby");
        initParams.put(ScriptPortlet.SOURCE, "classpath:org/apache/portals/bridges/script/HelloJRuby.rb");
        initParams.put(ScriptPortlet.VALIDATOR, "classpath:org/apache/portals/bridges/script/HelloJRubyPrefsValidator.rb");
        initParams.put(ScriptPortlet.AUTO_REFRESH, "true");
        return initParams;
    }
    
    @Override
    protected ResourceBundle getPortletResourceBundle()
    {
        return new ListResourceBundle()
        {
            protected Object[][] getContents() 
            {
                return new Object[][] {
                    {"javax.portlet.title", "Hello JRuby Portlet"},
                    {"javax.portlet.short-title", "Hello JRuby"},
                    {"javax.portlet.keywords", "hello,jruby"}
                };
            }
        };
    }

    @Override
    protected String getScriptMimeType()
    {
        return "application/x-ruby";
    }
    
    @Override
    public void testInit() throws Exception
    {
        super.testInit();
    }
    
    @Override
    public void testRender() throws Exception
    {
        super.testRender();
    }
    
    @Override
    public void testProcessAction() throws Exception
    {
        super.testProcessAction();
    }
    
    @Override
    public void testProcessEvent() throws Exception
    {
        super.testProcessEvent();
    }
    
    @Override
    public void testServeResource() throws Exception
    {
        super.testServeResource();
    }
}
