/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.bridges.script;

import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;

import org.apache.commons.lang.SystemUtils;

/**
 * TestHelloRhinoScriptPortlet
 * 
 * @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
 * @version $Id: TestHelloRhinoScriptPortlet.java 936987 2010-04-22 18:01:59Z woonsan $
 */
public class TestHelloRhinoScriptPortlet extends AbstractSimpleScriptPortletTestCase
{
    @Override
    public void setUp() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.setUp();
    }
    
    @Override
    protected Map<String, String> getPortletInitParameters()
    {
        Map<String, String> initParams = new HashMap<String, String>();
        initParams.put(ScriptPortlet.ENGINE, "rhino");
        initParams.put(ScriptPortlet.SOURCE, "classpath:org/apache/portals/bridges/script/HelloRhino.js");
        initParams.put(ScriptPortlet.VALIDATOR, "classpath:org/apache/portals/bridges/script/HelloRhinoPrefsValidator.js");
        initParams.put(ScriptPortlet.AUTO_REFRESH, "true");
        return initParams;
    }
    
    @Override
    protected ResourceBundle getPortletResourceBundle()
    {
        return new ListResourceBundle()
        {
            protected Object[][] getContents() 
            {
                return new Object[][] {
                    {"javax.portlet.title", "Hello Rhino Portlet"},
                    {"javax.portlet.short-title", "Hello Rhino"},
                    {"javax.portlet.keywords", "hello,rhino,js"}
                };
            }
        };
    }

    @Override
    protected String getScriptMimeType()
    {
        return "application/x-javascript";
    }
    
    @Override
    public void testInit() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.testInit();
    }
    
    @Override
    public void testRender() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.testRender();
    }
    
    @Override
    public void testProcessAction() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.testProcessAction();
    }
    
    @Override
    public void testProcessEvent() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.testProcessEvent();
    }
    
    @Override
    public void testServeResource() throws Exception
    {
        if (SystemUtils.isJavaVersionAtLeast(160))
        {
            System.out.println("[WARNING] Rhino script engine embedded in the default Java 1.6+ has not fully tested yet.");
            return;
        }
        
        super.testServeResource();
    }
}
