#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
# 
#      http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'java'

#
# @author <a href="mailto:woonsan@apache.org">Woonsan Ko</a>
# @version $Id: HelloJRubyPrefsValidator.rb 936949 2010-04-22 16:44:40Z woonsan $
#
class HelloJRubyPrefsValidator
    include javax.portlet.PreferencesValidator
    
    def validate(preferences)
        message = preferences.getValue("message", "")
        
        if !message
            throw new ValidatorException("Invalid message", null)
        end
    end
    
end

# Return validator instance as a last evaluated object
HelloJRubyPrefsValidator.new
