/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.portlets.rpad.PortletApplication;
import org.apache.jetspeed.portlets.rpad.RPADException;
import org.apache.jetspeed.portlets.rpad.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RepositoryManager.class);
    private static boolean init = false;
    private Map<String, Repository> repositories;
    private static RepositoryManager repositoryManager;

    public RepositoryManager(Map<String, Repository> repos) {
        this.repositories = repos;
    }

    public void load() {
        Iterator repoNames = this.repositories.keySet().iterator();
        Repository localRepository = null;
        while (repoNames.hasNext()) {
            localRepository = (Repository)this.repositories.get(repoNames.next());
            localRepository.init();
        }
        init = true;
    }

    public static RepositoryManager getInstance(Map<String, Repository> repos) {
        if (repositoryManager == null) {
            repositoryManager = new RepositoryManager(repos);
        }
        return repositoryManager;
    }

    public void reload(Map<String, Repository> repos) {
        this.repositories = repos;
        repositoryManager = new RepositoryManager(repos);
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(String name, Repository repository) throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            if (this.repositories.containsKey(name)) {
                throw new RPADException(name + "exists.");
            }
            this.repositories.put(name, repository);
            this.store();
        }
    }

    public Repository getRepository(String name) {
        return (Repository)this.repositories.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(String name) throws RPADException {
        Map map = this.repositories;
        synchronized (map) {
            if (!this.repositories.containsKey(name)) {
                throw new RPADException(name + "does not exist.");
            }
            this.repositories.remove(name);
            this.store();
        }
    }

    public List<Repository> getRepositories() {
        if (!init) {
            this.load();
        }
        return new ArrayList<Repository>(this.repositories.values());
    }

    public void store() throws RPADException {
    }

    public List<PortletApplication> getPortletApplications() {
        if (!init) {
            this.load();
        }
        ArrayList<PortletApplication> list = new ArrayList<PortletApplication>();
        for (Map.Entry entry : this.repositories.entrySet()) {
            List portlets;
            Repository repo = (Repository)entry.getValue();
            if (!repo.isAvailable() || (portlets = repo.getPortletApplications()) == null) continue;
            list.addAll(portlets);
        }
        return list;
    }

    public List<PortletApplication> getPortletApplications(String name) {
        List portlets;
        if (!init) {
            this.load();
        }
        ArrayList<PortletApplication> list = new ArrayList<PortletApplication>();
        Repository repo = this.getRepository(name);
        if (repo != null && repo.isAvailable() && (portlets = repo.getPortletApplications()) != null) {
            list.addAll(portlets);
        }
        return list;
    }
}

