/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.site;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.portlets.site.JetspeedDocumentMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedDocument
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(JetspeedDocument.class);
    private static final long serialVersionUID = -7429444774638220814L;
    private String name;
    private String title;
    private String shortTitle;
    private String pageDecorator;
    private String portletDecorator;
    private String desktopTheme;
    private boolean hidden;
    private List securityConstraints;
    private String page;
    private String target;
    private String url;
    private String path;
    private List<JetspeedDocumentMetaData> metaData;
    private List<String> documentOrder;
    private String type;

    public JetspeedDocument() {
    }

    public JetspeedDocument(Folder folder) {
        this.type = "folder";
        this.path = folder.getPath();
        this.name = folder.getName();
        this.title = folder.getTitle();
        this.shortTitle = folder.getTitle();
        this.hidden = folder.isHidden();
        this.page = folder.getDefaultPage();
        this.pageDecorator = folder.getDefaultDecorator("layout");
        this.portletDecorator = folder.getDefaultDecorator("portlet");
        this.loadMetaData(folder.getMetadata());
        this.loadSecurityData(folder.getSecurityConstraints());
        this.loadDocumentOrder(folder.getDocumentOrder());
    }

    public JetspeedDocument(Page page) {
        this.type = "page";
        this.path = page.getPath();
        this.name = page.getName();
        this.title = page.getTitle();
        this.shortTitle = page.getShortTitle();
        this.hidden = page.isHidden();
        this.pageDecorator = page.getDefaultDecorator("layout");
        this.portletDecorator = page.getDefaultDecorator("portlet");
        this.desktopTheme = page.getSkin();
        this.loadMetaData(page.getMetadata());
        this.loadSecurityData(page.getSecurityConstraints());
    }

    public JetspeedDocument(Link link) {
        this.type = "link";
        this.path = link.getPath();
        this.name = link.getName();
        this.title = link.getTitle();
        this.shortTitle = link.getShortTitle();
        this.hidden = link.isHidden();
        this.target = link.getTarget();
        this.url = link.getUrl();
        this.loadMetaData(link.getMetadata());
        this.loadSecurityData(link.getSecurityConstraints());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.getEscapedName(name);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public String getPageDecorator() {
        return this.pageDecorator;
    }

    public void setPageDecorator(String pageDecorator) {
        this.pageDecorator = pageDecorator;
    }

    public String getPortletDecorator() {
        return this.portletDecorator;
    }

    public void setPortletDecorator(String portletDecorator) {
        this.portletDecorator = portletDecorator;
    }

    public String getDesktopTheme() {
        return this.desktopTheme;
    }

    public void setDesktopTheme(String desktopTheme) {
        this.desktopTheme = desktopTheme;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(List securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public List<JetspeedDocumentMetaData> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(List<JetspeedDocumentMetaData> metaData) {
        this.metaData = metaData;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getDocumentOrder() {
        return this.documentOrder;
    }

    public void setDocumentOrder(List<String> documentOrder) {
        this.documentOrder = documentOrder;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void loadSecurityData(SecurityConstraints constraints) {
        this.securityConstraints = new ArrayList();
        if (constraints != null) {
            this.securityConstraints.addAll(constraints.getSecurityConstraintsRefs());
        }
    }

    private void loadMetaData(GenericMetadata objectMetaData) {
        this.metaData = new ArrayList();
        if (objectMetaData.getFields() != null) {
            for (LocalizedField field : objectMetaData.getFields()) {
                this.metaData.add(new JetspeedDocumentMetaData(field.getName(), field.getLocale().toString(), field.getValue()));
            }
        }
    }

    private void loadDocumentOrder(List documentOrder) {
        this.documentOrder = new ArrayList();
        for (int index = 0; index < documentOrder.size(); ++index) {
            this.documentOrder.add(documentOrder.get(index).toString());
        }
    }

    protected String getEscapedName(String pageName) {
        if (pageName == null) {
            return pageName;
        }
        try {
            return URLEncoder.encode(pageName, "UTF-8").replace('%', '_');
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Unsupported encoding: UTF-8");
            return pageName;
        }
    }
}

