/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.sso;

import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portlets.sso.JetspeedSSOSiteCredentials;
import org.apache.jetspeed.security.JSSubject;
import org.apache.jetspeed.security.PasswordCredential;
import org.apache.jetspeed.sso.SSOManager;
import org.apache.jetspeed.sso.SSOSite;
import org.apache.jetspeed.sso.SSOUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JetspeedSSOUtils {
    private static Logger log = LoggerFactory.getLogger(JetspeedSSOUtils.class);

    private JetspeedSSOUtils() {
    }

    public static List<JetspeedSSOSiteCredentials> getSubjectSSOSiteCredentials(SSOManager ssoManager) {
        ArrayList<JetspeedSSOSiteCredentials> ssoCredsList = new ArrayList<JetspeedSSOSiteCredentials>();
        try {
            Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
            Collection ssoSites = ssoManager.getSitesForSubject(subject);
            if (ssoSites != null) {
                URI siteURI = null;
                String scheme = "http";
                String host = null;
                int port = 80;
                for (SSOSite ssoSite : ssoSites) {
                    Collection ssoUsers;
                    siteURI = URI.create(ssoSite.getURL());
                    if (StringUtils.isNotEmpty((String)siteURI.getScheme())) {
                        scheme = siteURI.getScheme();
                    }
                    if (StringUtils.isEmpty((String)(host = siteURI.getHost()))) {
                        log.warn("Skipping invalid SSO site URI (no host): '{}'.", (Object)host);
                        continue;
                    }
                    if (siteURI.getPort() > 0) {
                        port = siteURI.getPort();
                    }
                    if ((ssoUsers = ssoManager.getRemoteUsers(ssoSite, subject)) == null) continue;
                    for (SSOUser ssoUser : ssoUsers) {
                        String realm = ssoSite.getRealm();
                        PasswordCredential pwc = ssoManager.getCredentials(ssoUser);
                        JetspeedSSOSiteCredentials ssoCreds = new JetspeedSSOSiteCredentials(siteURI, host, port, realm);
                        ssoCreds.setScheme(scheme);
                        ssoCreds.setChallengeResponseAuthentication(ssoSite.isChallengeResponseAuthentication());
                        ssoCreds.setFormAuthentication(ssoSite.isFormAuthentication());
                        ssoCreds.setFormUserField(ssoSite.getFormUserField());
                        ssoCreds.setFormPwdField(ssoSite.getFormPwdField());
                        ssoCreds.setUsername(pwc.getUserName());
                        ssoCreds.setPassword(pwc.getPassword());
                        ssoCredsList.add(ssoCreds);
                    }
                }
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to retrieve sso site credentials.", (Throwable)e);
            }
            log.warn("Failed to retrieve sso site credentials. {}", (Object)e.toString());
        }
        return ssoCredsList;
    }

    public static SSOSite getBestSubjectSSOSiteByURL(SSOManager ssoManager, String url) {
        SSOSite ssoSite = null;
        try {
            ssoSite = ssoManager.getSiteByUrl(url);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to retrieve sso site by url: " + url, (Throwable)e);
            }
            log.warn("Failed to retrieve sso site by url: '{}'. {}", (Object)url, (Object)e.toString());
        }
        if (ssoSite == null) {
            try {
                Subject subject = JSSubject.getSubject((AccessControlContext)AccessController.getContext());
                Collection ssoSites = ssoManager.getSitesForSubject(subject);
                if (ssoSites != null) {
                    ssoSite = JetspeedSSOUtils.getBestMatchedSSOSite((Collection)ssoSites, (URI)URI.create(url));
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to retrieve sso site.", (Throwable)e);
                }
                log.warn("Failed to retrieve sso site. {}", (Object)e.toString());
            }
        }
        return ssoSite;
    }

    public static SSOSite getBestMatchedSSOSite(Collection<SSOSite> ssoSites, URI uri) {
        if (ssoSites == null || ssoSites.isEmpty()) {
            return null;
        }
        SSOSite ssoSite = null;
        URI siteURI = null;
        ArrayList<SSOSite> candidates = new ArrayList<SSOSite>();
        for (SSOSite candidate : ssoSites) {
            siteURI = URI.create(candidate.getURL());
            if (!JetspeedSSOUtils.isEachFromSameOrigin((URI)uri, (URI)siteURI)) continue;
            candidates.add(candidate);
        }
        if (!candidates.isEmpty()) {
            if (candidates.size() == 1) {
                ssoSite = (SSOSite)candidates.get(0);
            } else {
                Collections.sort(candidates, new /* Unavailable Anonymous Inner Class!! */);
                ssoSite = (SSOSite)candidates.get(candidates.size() - 1);
            }
        }
        return ssoSite;
    }

    public static JetspeedSSOSiteCredentials getBestMatchedSSOSiteCrendentials(Collection<JetspeedSSOSiteCredentials> ssoSiteCredsList, URI uri) {
        if (ssoSiteCredsList == null || ssoSiteCredsList.isEmpty()) {
            return null;
        }
        JetspeedSSOSiteCredentials ssoSiteCreds = null;
        URI siteURI = null;
        ArrayList<JetspeedSSOSiteCredentials> candidates = new ArrayList<JetspeedSSOSiteCredentials>();
        for (JetspeedSSOSiteCredentials candidate : ssoSiteCredsList) {
            siteURI = candidate.getBaseURI();
            if (!JetspeedSSOUtils.isEachFromSameOrigin((URI)uri, (URI)siteURI)) continue;
            candidates.add(candidate);
        }
        if (!candidates.isEmpty()) {
            if (candidates.size() == 1) {
                ssoSiteCreds = (JetspeedSSOSiteCredentials)candidates.get(0);
            } else {
                Collections.sort(candidates, new /* Unavailable Anonymous Inner Class!! */);
                ssoSiteCreds = (JetspeedSSOSiteCredentials)candidates.get(candidates.size() - 1);
            }
        }
        return ssoSiteCreds;
    }

    private static boolean isEachFromSameOrigin(URI uri1, URI uri2) {
        return StringUtils.equals((String)uri1.getScheme(), (String)uri2.getScheme()) && StringUtils.equals((String)uri1.getHost(), (String)uri2.getHost()) && uri1.getPort() == uri2.getPort();
    }
}

