/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.toolbox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.request.RequestContext;

public class LayoutBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String title;
    private String image;
    private boolean selected;
    private String layoutPortlet;

    public LayoutBean(String name, String title, String image, String layoutPortlet) {
        this.setName(name);
        this.setTitle(title);
        this.setImage(image);
        this.setLayoutPortlet(layoutPortlet);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getLayoutPortlet() {
        return this.layoutPortlet;
    }

    public void setLayoutPortlet(String layoutPortlet) {
        this.layoutPortlet = layoutPortlet;
    }

    public static List<LayoutBean> retrieveLayouts(PortletRequest request, DecorationFactory decorationFactory) {
        ArrayList<LayoutBean> layouts = (ArrayList<LayoutBean>)request.getPortletSession().getAttribute("layouts");
        if (layouts == null) {
            layouts = new ArrayList<LayoutBean>();
            LayoutBean single = new LayoutBean("OneColumn", "One Column", "OneColumn.jpg", "jetspeed-layouts::VelocityOneColumn");
            layouts.add(single);
            LayoutBean twoColumns = new LayoutBean("TwoColumn", "Two Columns", "TwoColumns.jpg", "jetspeed-layouts::VelocityTwoColumns");
            layouts.add(twoColumns);
            LayoutBean threeColumns = new LayoutBean("ThreeColumn", "Three Columns", "ThreeColumns.jpg", "jetspeed-layouts::VelocityThreeColumns");
            layouts.add(threeColumns);
            LayoutBean fourColumns = new LayoutBean("FourColumn", "Four Columns", "FourColumns.jpg", "jetspeed-layouts::VelocityFourColumns");
            layouts.add(fourColumns);
            request.getPortletSession().setAttribute("layouts", layouts);
        }
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        ContentPage page = rc.getPage();
        ContentFragment layoutFragment = page.getNonTemplateRootFragment();
        String currentLayoutName = layoutFragment.getName();
        for (LayoutBean layout : layouts) {
            layout.setSelected(StringUtils.equals((String)currentLayoutName, (String)layout.getLayoutPortlet()));
        }
        return layouts;
    }
}

